/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.table.UserComparator;

public class InternalKeyComparator
implements Comparator<InternalKey> {
    private final UserComparator userComparator;

    public InternalKeyComparator(UserComparator userComparator) {
        this.userComparator = userComparator;
    }

    public UserComparator getUserComparator() {
        return this.userComparator;
    }

    public String name() {
        return this.userComparator.name();
    }

    @Override
    public int compare(InternalKey left, InternalKey right) {
        int result = this.userComparator.compare(left.getUserKey(), right.getUserKey());
        if (result != 0) {
            return result;
        }
        return Longs.compare(right.getSequenceNumber(), left.getSequenceNumber());
    }

    public boolean isOrdered(InternalKey ... keys) {
        return this.isOrdered(Arrays.asList(keys));
    }

    public boolean isOrdered(Iterable<InternalKey> keys) {
        Iterator<InternalKey> iterator = keys.iterator();
        if (!iterator.hasNext()) {
            return true;
        }
        InternalKey previous = iterator.next();
        while (iterator.hasNext()) {
            InternalKey next = iterator.next();
            if (this.compare(previous, next) > 0) {
                return false;
            }
            previous = next;
        }
        return true;
    }
}

