/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.concurrent;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.linkedin.util.clock.Timespan;
import org.linkedin.util.concurrent.ConcurrentUtils;
import org.linkedin.util.lang.LangUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadControl {
    public static final String MODULE = ThreadControl.class.getName();
    public static final Logger log = LoggerFactory.getLogger((String)MODULE);
    private final Lock _lock = new ReentrantLock();
    private final Condition _unblockCondition = this._lock.newCondition();
    private final Condition _blockCondition = this._lock.newCondition();
    private final Map<Object, Object> _waitingForUnblock = new HashMap<Object, Object>();
    private final Set<Object> _waitingForBlock = new HashSet<Object>();
    private final Timespan _timeout;

    public ThreadControl() {
        this(Timespan.ONE_SECOND);
    }

    public ThreadControl(Timespan timeout) {
        this._timeout = timeout;
    }

    public Timespan getTimeout() {
        return this._timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object block(Object key) {
        if (log.isDebugEnabled()) {
            log.debug(LangUtils.shortIdentityString(this) + ".block(" + key + ")");
        }
        this._lock.lock();
        try {
            this._waitingForBlock.add(key);
            this._blockCondition.signalAll();
            long endTime = System.currentTimeMillis() + this._timeout.getDurationInMilliseconds();
            while (!this._waitingForUnblock.containsKey(key)) {
                try {
                    ConcurrentUtils.awaitUntil(this._unblockCondition, endTime);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (TimeoutException e) {
                    throw new RuntimeException(e);
                }
            }
            Object object = this._waitingForUnblock.remove(key);
            return object;
        }
        finally {
            this._lock.unlock();
        }
    }

    public Object blockWithException(Object key) throws Exception {
        Object value = this.block(key);
        if (value instanceof Exception) {
            Exception exception = (Exception)value;
            throw exception;
        }
        return value;
    }

    public void unblock(Object key) {
        this.unblock(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblock(Object key, Object value) {
        if (log.isDebugEnabled()) {
            log.debug(LangUtils.shortIdentityString(this) + ".unblock(" + key + ", " + value + ")");
        }
        this._lock.lock();
        try {
            try {
                this.waitForBlock(key);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (TimeoutException e) {
                throw new RuntimeException(e);
            }
            this._waitingForBlock.remove(key);
            this._waitingForUnblock.put(key, value);
            this._unblockCondition.signalAll();
        }
        finally {
            this._lock.unlock();
        }
    }

    public void waitForBlock(Object key) throws TimeoutException, InterruptedException {
        this.waitForBlock(key, this._timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForBlock(Object key, Timespan timeout) throws TimeoutException, InterruptedException {
        this._lock.lock();
        try {
            long endTime = System.currentTimeMillis() + timeout.getDurationInMilliseconds();
            while (!this._waitingForBlock.contains(key)) {
                ConcurrentUtils.awaitUntil(this._blockCondition, endTime);
            }
        }
        finally {
            this._lock.unlock();
        }
    }
}

