/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.blueprint.cm;

import java.util.Map;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.jexl2.UnifiedJEXL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JexlExpressionParser {
    private static final Logger log = LoggerFactory.getLogger(JexlExpressionParser.class);
    private final JexlEngine engine;
    private final UnifiedJEXL jexl;
    protected final JexlContext context;

    public JexlExpressionParser(Map<String, Object> vars) {
        if (vars == null) {
            throw new IllegalArgumentException("vars");
        }
        this.engine = new JexlEngine();
        this.jexl = new UnifiedJEXL(this.engine);
        this.context = new MapContext(vars);
        log.trace("Using variables: {}", vars);
    }

    public Object evaluate(String expression) throws Exception {
        if (expression == null) {
            throw new IllegalArgumentException("expression");
        }
        log.trace("Evaluating expression: {}", (Object)expression);
        return this.jexl.parse(expression).evaluate(this.context);
    }
}

