/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.InitialContext;
import javax.servlet.ServletContext;
import org.apache.cxf.resource.ResourceResolver;

public class ServletContextResourceResolver
implements ResourceResolver {
    ServletContext servletContext;
    Map<String, URL> urlMap = new ConcurrentHashMap<String, URL>();

    public ServletContextResourceResolver(ServletContext sc) {
        this.servletContext = sc;
    }

    public final InputStream getAsStream(String string) {
        if (this.urlMap.containsKey(string)) {
            try {
                return this.urlMap.get(string).openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.servletContext.getResourceAsStream(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T resolve(String entryName, Class<T> clz) {
        Object obj;
        block20: {
            obj = null;
            try {
                if (entryName == null) break block20;
                try (InitialContext ic = new InitialContext();){
                    obj = ic.lookup(entryName);
                }
            }
            catch (Throwable ic) {
                // empty catch block
            }
        }
        if (obj != null && clz.isInstance(obj)) {
            return clz.cast(obj);
        }
        if (clz.isAssignableFrom(URL.class)) {
            URL url2;
            if (this.urlMap.containsKey(entryName)) {
                return clz.cast(this.urlMap.get(entryName));
            }
            try {
                url2 = this.servletContext.getResource(entryName);
                if (url2 != null && "file".equals(url2.getProtocol()) && !new File(url2.toURI()).exists()) {
                    url2 = null;
                }
                if (url2 != null) {
                    this.urlMap.put(url2.toString(), url2);
                    return clz.cast(url2);
                }
            }
            catch (MalformedURLException url2) {
            }
            catch (URISyntaxException url2) {
                // empty catch block
            }
            try {
                url2 = this.servletContext.getResource("/" + entryName);
                if (url2 != null && "file".equals(url2.getProtocol()) && !new File(url2.toURI()).exists()) {
                    url2 = null;
                }
                if (url2 != null) {
                    this.urlMap.put(url2.toString(), url2);
                    return clz.cast(url2);
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (URISyntaxException uRISyntaxException) {}
        } else if (clz.isAssignableFrom(InputStream.class)) {
            return clz.cast(this.getAsStream(entryName));
        }
        return null;
    }
}

