/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.runtime.dto;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.felix.http.base.internal.runtime.ServletContextHelperInfo;
import org.apache.felix.http.base.internal.runtime.dto.BuilderConstants;
import org.osgi.dto.DTO;
import org.osgi.service.http.runtime.dto.FailedServletContextDTO;
import org.osgi.service.http.runtime.dto.ServletContextDTO;

public final class ServletContextDTOBuilder {
    public static ServletContextDTO build(ServletContextHelperInfo info, ServletContext context, int reason) {
        ServletContextDTO dto = reason == -1 ? new ServletContextDTO() : new FailedServletContextDTO();
        dto.attributes = ServletContextDTOBuilder.getAttributes(context);
        dto.contextPath = context != null ? context.getContextPath() : info.getPath();
        dto.initParams = info.getInitParameters();
        dto.name = info.getName();
        dto.serviceId = info.getServiceId();
        dto.errorPageDTOs = BuilderConstants.ERROR_PAGE_DTO_ARRAY;
        dto.filterDTOs = BuilderConstants.FILTER_FAILURE_DTO_ARRAY;
        dto.listenerDTOs = BuilderConstants.LISTENER_DTO_ARRAY;
        dto.resourceDTOs = BuilderConstants.RESOURCE_DTO_ARRAY;
        dto.servletDTOs = BuilderConstants.SERVLET_DTO_ARRAY;
        if (reason != -1) {
            ((FailedServletContextDTO)dto).failureReason = reason;
        }
        return dto;
    }

    private static Map<String, Object> getAttributes(ServletContext context) {
        if (context == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (String name : Collections.list(context.getAttributeNames())) {
            Object attribute = context.getAttribute(name);
            if (!ServletContextDTOBuilder.isSupportedType(attribute)) continue;
            attributes.put(name, attribute);
        }
        return attributes;
    }

    private static boolean isSupportedType(Object attribute) {
        Class<?> attributeClass = attribute.getClass();
        Class<?> type = !attributeClass.isArray() ? attributeClass : attributeClass.getComponentType();
        return Number.class.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type) || String.class.isAssignableFrom(type) || DTO.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type) || Character.TYPE.isAssignableFrom(type);
    }
}

