/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp;

import java.io.IOException;
import org.apache.shardingsphere.shade.io.opentelemetry.api.incubator.logs.KeyAnyValue;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.AnyValueStatelessMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.proto.common.v1.internal.KeyValue;

public final class KeyValueStatelessMarshaler
implements StatelessMarshaler<KeyAnyValue> {
    public static final KeyValueStatelessMarshaler INSTANCE = new KeyValueStatelessMarshaler();
    private static final byte[] EMPTY_BYTES = new byte[0];

    private KeyValueStatelessMarshaler() {
    }

    @Override
    public void writeTo(Serializer output, KeyAnyValue value, MarshalerContext context) throws IOException {
        String key = value.getKey();
        if (key.isEmpty()) {
            output.serializeString(KeyValue.KEY, EMPTY_BYTES);
        } else {
            output.serializeStringWithContext(KeyValue.KEY, key, context);
        }
        output.serializeMessageWithContext(KeyValue.VALUE, value.getAnyValue(), AnyValueStatelessMarshaler.INSTANCE, context);
    }

    @Override
    public int getBinarySerializedSize(KeyAnyValue value, MarshalerContext context) {
        int size = 0;
        String key = value.getKey();
        if (!key.isEmpty()) {
            size += StatelessMarshalerUtil.sizeStringWithContext(KeyValue.KEY, key, context);
        }
        return size += StatelessMarshalerUtil.sizeMessageWithContext(KeyValue.VALUE, value.getAnyValue(), AnyValueStatelessMarshaler.INSTANCE, context);
    }
}

