/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.event.subscriber.dispatch;

import com.google.common.eventbus.Subscribe;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.util.eventbus.EventSubscriber;
import org.apache.shardingsphere.mode.event.dispatch.state.compute.ComputeNodeInstanceStateChangedEvent;
import org.apache.shardingsphere.mode.event.dispatch.state.compute.LabelsEvent;
import org.apache.shardingsphere.mode.event.dispatch.state.compute.WorkerIdEvent;
import org.apache.shardingsphere.mode.event.dispatch.state.compute.instance.InstanceOfflineEvent;
import org.apache.shardingsphere.mode.event.dispatch.state.compute.instance.InstanceOnlineEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class ComputeNodeStateSubscriber
implements EventSubscriber {
    private final ContextManager contextManager;

    @Subscribe
    public synchronized void renew(InstanceOnlineEvent event) {
        this.contextManager.getComputeNodeInstanceContext().addComputeNodeInstance(this.contextManager.getPersistServiceFacade().getComputeNodePersistService().loadComputeNodeInstance(event.getInstanceMetaData()));
    }

    @Subscribe
    public synchronized void renew(InstanceOfflineEvent event) {
        this.contextManager.getComputeNodeInstanceContext().deleteComputeNodeInstance(new ComputeNodeInstance(event.getInstanceMetaData()));
    }

    @Subscribe
    public synchronized void renew(ComputeNodeInstanceStateChangedEvent event) {
        this.contextManager.getComputeNodeInstanceContext().updateStatus(event.getInstanceId(), event.getStatus());
    }

    @Subscribe
    public synchronized void renew(WorkerIdEvent event) {
        this.contextManager.getComputeNodeInstanceContext().updateWorkerId(event.getInstanceId(), event.getWorkerId());
    }

    @Subscribe
    public synchronized void renew(LabelsEvent event) {
        this.contextManager.getComputeNodeInstanceContext().updateLabel(event.getInstanceId(), event.getLabels());
    }

    @Generated
    public ComputeNodeStateSubscriber(ContextManager contextManager) {
        this.contextManager = contextManager;
    }
}

