/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.persist;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.process.Process;
import org.apache.shardingsphere.infra.executor.sql.process.lock.ProcessOperationLockRegistry;
import org.apache.shardingsphere.infra.executor.sql.process.yaml.YamlProcessList;
import org.apache.shardingsphere.infra.executor.sql.process.yaml.swapper.YamlProcessListSwapper;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.metadata.persist.node.ComputeNode;
import org.apache.shardingsphere.metadata.persist.node.ProcessNode;
import org.apache.shardingsphere.mode.persist.service.ProcessPersistService;
import org.apache.shardingsphere.mode.spi.PersistRepository;

public final class ClusterProcessPersistService
implements ProcessPersistService {
    private final PersistRepository repository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Process> getProcessList() {
        String taskId = new UUID(ThreadLocalRandom.current().nextLong(), ThreadLocalRandom.current().nextLong()).toString().replace("-", "");
        Collection<String> triggerPaths = this.getShowProcessListTriggerPaths(taskId);
        boolean isCompleted = false;
        try {
            triggerPaths.forEach(each -> this.repository.persist(each, ""));
            isCompleted = ProcessOperationLockRegistry.getInstance().waitUntilReleaseReady(taskId, () -> this.isReady(triggerPaths));
            Collection<Process> collection = this.getShowProcessListData(taskId);
            return collection;
        }
        finally {
            this.repository.delete(ProcessNode.getProcessIdPath((String)taskId));
            if (!isCompleted) {
                triggerPaths.forEach(arg_0 -> ((PersistRepository)this.repository).delete(arg_0));
            }
        }
    }

    private Collection<Process> getShowProcessListData(String taskId) {
        YamlProcessList yamlProcessList = new YamlProcessList();
        for (String each2 : this.repository.getChildrenKeys(ProcessNode.getProcessIdPath((String)taskId)).stream().map(each -> this.repository.query(ProcessNode.getProcessListInstancePath((String)taskId, (String)each))).collect(Collectors.toList())) {
            yamlProcessList.getProcesses().addAll(((YamlProcessList)YamlEngine.unmarshal((String)each2, YamlProcessList.class)).getProcesses());
        }
        return new YamlProcessListSwapper().swapToObject(yamlProcessList);
    }

    private Collection<String> getShowProcessListTriggerPaths(String taskId) {
        return Stream.of(InstanceType.values()).flatMap(each -> this.repository.getChildrenKeys(ComputeNode.getOnlineNodePath((InstanceType)each)).stream().map(onlinePath -> ComputeNode.getProcessTriggerInstanceNodePath((String)onlinePath, (String)taskId))).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killProcess(String processId) {
        Collection<String> triggerPaths = this.getKillProcessTriggerPaths(processId);
        boolean isCompleted = false;
        try {
            triggerPaths.forEach(each -> this.repository.persist(each, ""));
            isCompleted = ProcessOperationLockRegistry.getInstance().waitUntilReleaseReady(processId, () -> this.isReady(triggerPaths));
        }
        finally {
            if (!isCompleted) {
                triggerPaths.forEach(arg_0 -> ((PersistRepository)this.repository).delete(arg_0));
            }
        }
    }

    private Collection<String> getKillProcessTriggerPaths(String processId) {
        return Stream.of(InstanceType.values()).flatMap(each -> this.repository.getChildrenKeys(ComputeNode.getOnlineNodePath((InstanceType)each)).stream().map(onlinePath -> ComputeNode.getProcessKillInstanceIdNodePath((String)onlinePath, (String)processId))).collect(Collectors.toList());
    }

    private boolean isReady(Collection<String> paths) {
        return paths.stream().noneMatch(each -> null != this.repository.query(each));
    }

    @Generated
    public ClusterProcessPersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

