/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.thread.InterruptedExceptionHelper;

class ConditionalWaiter {
    private static final Logger LOGGER = LoggerFactory.createLogger(ConditionalWaiter.class);
    private long maxWaitTime;

    ConditionalWaiter(long maxWaitTime) {
        this.maxWaitTime = maxWaitTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean waitWhile(Condition condition) {
        int waitTime = 1000;
        boolean evaluation = condition.evaluate();
        for (long accumulatedWaitTime = 0L; evaluation && accumulatedWaitTime < this.maxWaitTime; accumulatedWaitTime += (long)waitTime) {
            LOGGER.logInfo("Waiting for condition to become true...");
            ConditionalWaiter conditionalWaiter = this;
            synchronized (conditionalWaiter) {
                block6: {
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException ex) {
                        InterruptedExceptionHelper.handleInterruptedException((InterruptedException)ex);
                        if (!LOGGER.isTraceEnabled()) break block6;
                        LOGGER.logTrace(this + ": interrupted during wait", (Throwable)ex);
                    }
                }
            }
            evaluation = condition.evaluate();
        }
        return evaluation;
    }

    @FunctionalInterface
    static interface Condition {
        public boolean evaluate();
    }
}

