/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shadow.rule;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.infra.algorithm.core.config.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.rule.attribute.RuleAttribute;
import org.apache.shardingsphere.infra.rule.attribute.RuleAttributes;
import org.apache.shardingsphere.infra.rule.scope.DatabaseRule;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.shadow.config.ShadowRuleConfiguration;
import org.apache.shardingsphere.shadow.config.datasource.ShadowDataSourceConfiguration;
import org.apache.shardingsphere.shadow.config.table.ShadowTableConfiguration;
import org.apache.shardingsphere.shadow.rule.ShadowAlgorithmNameRule;
import org.apache.shardingsphere.shadow.rule.ShadowDataSourceRule;
import org.apache.shardingsphere.shadow.rule.ShadowTableRule;
import org.apache.shardingsphere.shadow.rule.attribute.ShadowDataSourceMapperRuleAttribute;
import org.apache.shardingsphere.shadow.spi.ShadowAlgorithm;
import org.apache.shardingsphere.shadow.spi.ShadowOperationType;
import org.apache.shardingsphere.shadow.spi.column.ColumnShadowAlgorithm;
import org.apache.shardingsphere.shadow.spi.hint.HintShadowAlgorithm;

public final class ShadowRule
implements DatabaseRule {
    private final ShadowRuleConfiguration configuration;
    private final Collection<String> hintShadowAlgorithmNames = new LinkedList<String>();
    private final Map<String, ShadowDataSourceRule> shadowDataSourceMappings = new LinkedHashMap<String, ShadowDataSourceRule>();
    private final Map<String, ShadowAlgorithm> shadowAlgorithms = new LinkedHashMap<String, ShadowAlgorithm>();
    private final Map<String, ShadowTableRule> shadowTableRules = new LinkedHashMap<String, ShadowTableRule>();
    private final ShadowAlgorithm defaultShadowAlgorithm;
    private final RuleAttributes attributes;

    public ShadowRule(ShadowRuleConfiguration ruleConfig) {
        this.configuration = ruleConfig;
        this.initShadowDataSourceMappings(ruleConfig.getDataSources());
        this.initShadowAlgorithmConfigurations(ruleConfig.getShadowAlgorithms());
        this.defaultShadowAlgorithm = this.shadowAlgorithms.get(ruleConfig.getDefaultShadowAlgorithmName());
        if (this.defaultShadowAlgorithm instanceof HintShadowAlgorithm) {
            this.hintShadowAlgorithmNames.add(ruleConfig.getDefaultShadowAlgorithmName());
        }
        this.initShadowTableRules(ruleConfig.getTables());
        this.attributes = new RuleAttributes(new RuleAttribute[]{new ShadowDataSourceMapperRuleAttribute(this.shadowDataSourceMappings)});
    }

    private void initShadowDataSourceMappings(Collection<ShadowDataSourceConfiguration> dataSources) {
        dataSources.forEach(each -> this.shadowDataSourceMappings.put(each.getName(), new ShadowDataSourceRule(each.getProductionDataSourceName(), each.getShadowDataSourceName())));
    }

    private void initShadowAlgorithmConfigurations(Map<String, AlgorithmConfiguration> shadowAlgorithmConfigs) {
        shadowAlgorithmConfigs.forEach((key, value) -> {
            ShadowAlgorithm algorithm = (ShadowAlgorithm)TypedSPILoader.getService(ShadowAlgorithm.class, (Object)value.getType(), (Properties)value.getProps());
            if (algorithm instanceof HintShadowAlgorithm) {
                this.hintShadowAlgorithmNames.add((String)key);
            }
            this.shadowAlgorithms.put((String)key, algorithm);
        });
    }

    private void initShadowTableRules(Map<String, ShadowTableConfiguration> tables) {
        tables.forEach((key, value) -> this.shadowTableRules.put((String)key, new ShadowTableRule((String)key, value.getDataSourceNames(), value.getShadowAlgorithmNames(), this.shadowAlgorithms)));
    }

    public Optional<ShadowAlgorithm> getDefaultShadowAlgorithm() {
        return null == this.defaultShadowAlgorithm ? Optional.empty() : Optional.of(this.defaultShadowAlgorithm);
    }

    public Collection<String> getRelatedShadowTables(Collection<String> tableNames) {
        LinkedList<String> result = new LinkedList<String>();
        for (String each : tableNames) {
            if (!this.shadowTableRules.containsKey(each)) continue;
            result.add(each);
        }
        return result;
    }

    public Collection<String> getAllShadowTableNames() {
        return this.shadowTableRules.keySet();
    }

    public Collection<HintShadowAlgorithm<Comparable<?>>> getAllHintShadowAlgorithms() {
        LinkedList result = new LinkedList();
        for (String each : this.hintShadowAlgorithmNames) {
            result.add((HintShadowAlgorithm)this.shadowAlgorithms.get(each));
        }
        return result;
    }

    public Collection<HintShadowAlgorithm<Comparable<?>>> getRelatedHintShadowAlgorithms(String tableName) {
        LinkedList result = new LinkedList();
        Collection<String> hintShadowAlgorithmNames = this.shadowTableRules.get(tableName).getHintShadowAlgorithmNames();
        for (String each : hintShadowAlgorithmNames) {
            result.add((HintShadowAlgorithm)this.shadowAlgorithms.get(each));
        }
        return result;
    }

    public Collection<ColumnShadowAlgorithm<Comparable<?>>> getRelatedColumnShadowAlgorithms(ShadowOperationType shadowOperationType, String tableName, String shadowColumn) {
        LinkedList result = new LinkedList();
        Map<ShadowOperationType, Collection<ShadowAlgorithmNameRule>> columnShadowAlgorithmNames = this.shadowTableRules.get(tableName).getColumnShadowAlgorithmNames();
        Collection<ShadowAlgorithmNameRule> names = columnShadowAlgorithmNames.get(shadowOperationType);
        if (null == names) {
            return result;
        }
        for (ShadowAlgorithmNameRule each : names) {
            if (!shadowColumn.equals(each.getShadowColumnName())) continue;
            result.add((ColumnShadowAlgorithm)this.shadowAlgorithms.get(each.getShadowAlgorithmName()));
        }
        return result;
    }

    public Collection<String> getRelatedShadowColumnNames(ShadowOperationType shadowOperationType, String tableName) {
        LinkedList<String> result = new LinkedList<String>();
        Map<ShadowOperationType, Collection<ShadowAlgorithmNameRule>> columnShadowAlgorithmNames = this.shadowTableRules.get(tableName).getColumnShadowAlgorithmNames();
        Collection<ShadowAlgorithmNameRule> names = columnShadowAlgorithmNames.get(shadowOperationType);
        if (null == names) {
            return result;
        }
        for (ShadowAlgorithmNameRule each : names) {
            result.add(each.getShadowColumnName());
        }
        return result;
    }

    public Map<String, String> getRelatedShadowDataSourceMappings(String tableName) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Collection<String> shadowDataSources = this.shadowTableRules.get(tableName).getShadowDataSources();
        for (String each : shadowDataSources) {
            ShadowDataSourceRule shadowDataSourceRule = this.shadowDataSourceMappings.get(each);
            result.put(shadowDataSourceRule.getProductionDataSource(), shadowDataSourceRule.getShadowDataSource());
        }
        return result;
    }

    public Map<String, String> getAllShadowDataSourceMappings() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, ShadowDataSourceRule> entry : this.shadowDataSourceMappings.entrySet()) {
            ShadowDataSourceRule rule = entry.getValue();
            result.put(rule.getProductionDataSource(), rule.getShadowDataSource());
        }
        return result;
    }

    public Optional<String> getSourceDataSourceName(String actualDataSourceName) {
        ShadowDataSourceRule shadowDataSourceRule = this.shadowDataSourceMappings.get(actualDataSourceName);
        return null == shadowDataSourceRule ? Optional.empty() : Optional.of(shadowDataSourceRule.getProductionDataSource());
    }

    @Generated
    public ShadowRuleConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public Collection<String> getHintShadowAlgorithmNames() {
        return this.hintShadowAlgorithmNames;
    }

    @Generated
    public Map<String, ShadowDataSourceRule> getShadowDataSourceMappings() {
        return this.shadowDataSourceMappings;
    }

    @Generated
    public Map<String, ShadowAlgorithm> getShadowAlgorithms() {
        return this.shadowAlgorithms;
    }

    @Generated
    public Map<String, ShadowTableRule> getShadowTableRules() {
        return this.shadowTableRules;
    }

    @Generated
    public RuleAttributes getAttributes() {
        return this.attributes;
    }
}

