/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.url.core;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Properties;
import lombok.Generated;

public final class ShardingSphereURL {
    private final String sourceType;
    private final String configurationSubject;
    private final Properties queryProps;

    public static ShardingSphereURL parse(String url) {
        String sourceType = ShardingSphereURL.parseSourceType(url);
        return new ShardingSphereURL(sourceType, ShardingSphereURL.parseConfigurationSubject(url.substring(sourceType.length())), ShardingSphereURL.parseProperties(url));
    }

    private static String parseSourceType(String url) {
        return url.substring(0, url.indexOf(58) + 1);
    }

    private static String parseConfigurationSubject(String url) {
        String result = url.substring(0, url.contains("?") ? url.indexOf(63) : url.length());
        Preconditions.checkArgument((!result.isEmpty() ? 1 : 0) != 0, (Object)"Configuration subject is required in URL.");
        return result;
    }

    private static Properties parseProperties(String url) {
        if (!url.contains("?")) {
            return new Properties();
        }
        String queryProps = url.substring(url.indexOf(63) + 1);
        if (Strings.isNullOrEmpty((String)queryProps)) {
            return new Properties();
        }
        String[] pairs = queryProps.split("&");
        Properties result = new Properties();
        for (String each : pairs) {
            int index = each.indexOf("=");
            if (index <= 0) continue;
            result.put(each.substring(0, index), each.substring(index + 1));
        }
        return result;
    }

    @Generated
    private ShardingSphereURL(String sourceType, String configurationSubject, Properties queryProps) {
        this.sourceType = sourceType;
        this.configurationSubject = configurationSubject;
        this.queryProps = queryProps;
    }

    @Generated
    public String getSourceType() {
        return this.sourceType;
    }

    @Generated
    public String getConfigurationSubject() {
        return this.configurationSubject;
    }

    @Generated
    public Properties getQueryProps() {
        return this.queryProps;
    }
}

