/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import javax.transaction.xa.XAException;

public class XAExceptionHelper {
    public static String convertErrorCodeToVerboseMessage(int errorCode) {
        String msg = "unkown";
        switch (errorCode) {
            case -7: {
                msg = "the XA resource has become unavailable";
                break;
            }
            case 100: {
                msg = "the XA resource has rolled back for an unspecified reason";
                break;
            }
            case 101: {
                msg = "the XA resource rolled back due to a communication failure";
                break;
            }
            case 102: {
                msg = "the XA resource has rolled back because of a deadlock";
                break;
            }
            case 103: {
                msg = "the XA resource has rolled back due to a constraint violation";
                break;
            }
            case 104: {
                msg = "the XA resource has rolled back for an unknown reason";
                break;
            }
            case 105: {
                msg = "the XA resource has rolled back because it did not expect this command in the current context";
                break;
            }
            case 106: {
                msg = "the XA resource has rolled back because the transaction took too long";
                break;
            }
            case 107: {
                msg = "the XA resource has rolled back for a temporary reason - the transaction can be retried later";
                break;
            }
            case 9: {
                msg = "XA resume attempted in a different place from where suspend happened";
                break;
            }
            case 8: {
                msg = "the XA resource may have heuristically completed the transaction";
                break;
            }
            case 7: {
                msg = "the XA resource has heuristically committed";
                break;
            }
            case 6: {
                msg = "the XA resource has heuristically rolled back";
                break;
            }
            case 5: {
                msg = "the XA resource has heuristically committed some parts and rolled back other parts";
                break;
            }
            case 4: {
                msg = "the XA command had no effect and may be retried";
                break;
            }
            case 3: {
                msg = "the XA resource had no updates to perform for this transaction";
                break;
            }
            case -3: {
                msg = "the XA resource detected an internal error";
                break;
            }
            case -4: {
                msg = "the supplied XID is invalid for this XA resource";
                break;
            }
            case -5: {
                msg = "invalid arguments were given for the XA operation";
                break;
            }
            case -6: {
                msg = "the XA resource did not expect this command in the current context";
                break;
            }
            case -8: {
                msg = "the supplied XID already exists in this XA resource";
                break;
            }
            case -9: {
                msg = "the XA resource is currently involved in a local (non-XA) transaction";
                break;
            }
            default: {
                msg = "unknown";
            }
        }
        return msg;
    }

    public static String formatLogMessage(String msg, XAException e, String impact) {
        StringBuilder ret = new StringBuilder();
        ret.append(msg).append(": ").append(XAExceptionHelper.convertErrorCodeToVerboseMessage(e.errorCode)).append(" - ").append(impact);
        return ret.toString();
    }
}

