/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.util;

import java.sql.SQLException;
import java.sql.Statement;
import lombok.Generated;

public final class PipelineJdbcUtils {
    public static boolean isIntegerColumn(int columnType) {
        return 4 == columnType || -5 == columnType || 5 == columnType || -6 == columnType;
    }

    public static boolean isStringColumn(int columnType) {
        switch (columnType) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    public static boolean isBinaryColumn(int columnType) {
        switch (columnType) {
            case -4: 
            case -3: 
            case -2: {
                return true;
            }
        }
        return false;
    }

    public static void cancelStatement(Statement statement) {
        try {
            if (!statement.isClosed()) {
                statement.cancel();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Generated
    private PipelineJdbcUtils() {
    }
}

