/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.metadata.persist.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereDatabaseData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereSchemaData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereStatistics;
import org.apache.shardingsphere.infra.yaml.data.pojo.YamlShardingSphereRowData;
import org.apache.shardingsphere.infra.yaml.data.swapper.YamlShardingSphereRowDataSwapper;
import org.apache.shardingsphere.metadata.persist.data.AlteredShardingSphereDatabaseData;
import org.apache.shardingsphere.metadata.persist.node.ShardingSphereDataNode;
import org.apache.shardingsphere.metadata.persist.service.metadata.table.TableRowDataPersistService;
import org.apache.shardingsphere.mode.spi.PersistRepository;

public final class ShardingSphereDataPersistService {
    private final PersistRepository repository;
    private final TableRowDataPersistService tableRowDataPersistService;

    public ShardingSphereDataPersistService(PersistRepository repository) {
        this.repository = repository;
        this.tableRowDataPersistService = new TableRowDataPersistService(repository);
    }

    public Optional<ShardingSphereStatistics> load(ShardingSphereMetaData metaData) {
        List databaseNames = this.repository.getChildrenKeys(ShardingSphereDataNode.getShardingSphereDataNodePath());
        if (databaseNames.isEmpty()) {
            return Optional.empty();
        }
        ShardingSphereStatistics result = new ShardingSphereStatistics();
        for (String each : databaseNames.stream().filter(arg_0 -> ((ShardingSphereMetaData)metaData).containsDatabase(arg_0)).collect(Collectors.toList())) {
            result.getDatabaseData().put(each, this.load(each, metaData.getDatabase(each)));
        }
        return Optional.of(result);
    }

    private ShardingSphereDatabaseData load(String databaseName, ShardingSphereDatabase database) {
        ShardingSphereDatabaseData result = new ShardingSphereDatabaseData();
        for (String each : this.repository.getChildrenKeys(ShardingSphereDataNode.getSchemasPath(databaseName)).stream().filter(arg_0 -> ((ShardingSphereDatabase)database).containsSchema(arg_0)).collect(Collectors.toList())) {
            result.getSchemaData().put(each, this.load(databaseName, each, database.getSchema(each)));
        }
        return result;
    }

    private ShardingSphereSchemaData load(String databaseName, String schemaName, ShardingSphereSchema schema) {
        ShardingSphereSchemaData result = new ShardingSphereSchemaData();
        for (String each : this.repository.getChildrenKeys(ShardingSphereDataNode.getTablesPath(databaseName, schemaName)).stream().filter(arg_0 -> ((ShardingSphereSchema)schema).containsTable(arg_0)).collect(Collectors.toList())) {
            result.getTableData().put(each, this.tableRowDataPersistService.load(databaseName, schemaName, each, schema.getTable(each)));
        }
        return result;
    }

    public void persist(ShardingSphereDatabase database, String schemaName, ShardingSphereSchemaData schemaData) {
        if (schemaData.getTableData().isEmpty()) {
            this.persistSchema(database.getName(), schemaName);
        }
        this.persistTableData(database, schemaName, schemaData);
    }

    private void persistSchema(String databaseName, String schemaName) {
        this.repository.persist(ShardingSphereDataNode.getSchemaDataPath(databaseName, schemaName), "");
    }

    private void persistTableData(ShardingSphereDatabase database, String schemaName, ShardingSphereSchemaData schemaData) {
        schemaData.getTableData().values().forEach(each -> {
            YamlShardingSphereRowDataSwapper swapper = new YamlShardingSphereRowDataSwapper(new ArrayList(database.getSchema(schemaName).getTable(each.getName()).getColumnValues()));
            this.persistTableData(database.getName(), schemaName, each.getName(), each.getRows().stream().map(arg_0 -> ((YamlShardingSphereRowDataSwapper)swapper).swapToYamlConfiguration(arg_0)).collect(Collectors.toList()));
        });
    }

    private void persistTableData(String databaseName, String schemaName, String tableName, Collection<YamlShardingSphereRowData> rows) {
        this.tableRowDataPersistService.persist(databaseName, schemaName, tableName, rows);
    }

    public void update(AlteredShardingSphereDatabaseData alteredData) {
        this.tableRowDataPersistService.persist(alteredData.getDatabaseName(), alteredData.getSchemaName(), alteredData.getTableName(), alteredData.getAddedRows());
        this.tableRowDataPersistService.persist(alteredData.getDatabaseName(), alteredData.getSchemaName(), alteredData.getTableName(), alteredData.getUpdatedRows());
        this.tableRowDataPersistService.delete(alteredData.getDatabaseName(), alteredData.getSchemaName(), alteredData.getTableName(), alteredData.getDeletedRows());
    }

    public void delete(String databaseName) {
        this.repository.delete(ShardingSphereDataNode.getDatabaseNamePath(databaseName));
    }
}

