/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.reactivestreams;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import rx.Completable;
import rx.CompletableSubscriber;
import rx.Subscription;

public final class CompletableAsPublisher<T>
implements Publisher<T> {
    final Completable completable;

    public CompletableAsPublisher(Completable completable) {
        this.completable = completable;
    }

    public void subscribe(Subscriber<? super T> s) {
        if (s == null) {
            throw new NullPointerException();
        }
        this.completable.subscribe(new CompletableAsPublisherSubscriber<T>(s));
    }

    static final class CompletableAsPublisherSubscriber<T>
    implements CompletableSubscriber,
    org.reactivestreams.Subscription {
        final Subscriber<? super T> actual;
        Subscription d;

        public CompletableAsPublisherSubscriber(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        public void onSubscribe(Subscription d) {
            this.d = d;
            this.actual.onSubscribe((org.reactivestreams.Subscription)this);
        }

        public void onError(Throwable e) {
            this.actual.onError(e);
        }

        public void onCompleted() {
            this.actual.onComplete();
        }

        public void request(long n) {
        }

        public void cancel() {
            this.d.unsubscribe();
        }
    }
}

