/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.common;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import com.aliyun.openservices.log.common.AlertConfiguration;
import com.aliyun.openservices.log.common.JobType;
import com.aliyun.openservices.log.common.Query;
import com.aliyun.openservices.log.common.ScheduledJob;
import com.aliyun.openservices.log.util.Args;
import java.io.Serializable;
import java.util.List;

public class Alert
extends ScheduledJob
implements Serializable {
    private static final long serialVersionUID = 9211926785430833230L;
    @JSONField
    private AlertConfiguration configuration;

    public Alert() {
        this.setType(JobType.ALERT);
    }

    @Override
    public AlertConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AlertConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void deserialize(JSONObject value) {
        super.deserialize(value);
        this.configuration = new AlertConfiguration();
        this.configuration.deserialize(value.getJSONObject("configuration"));
    }

    public void validate() {
        Args.notNullOrEmpty(this.getName(), "name");
        Args.notNullOrEmpty(this.getDisplayName(), "displayName");
        Args.notNull(this.configuration, "configuration");
        List<Query> queries = this.configuration.getQueryList();
        Args.notNullOrEmpty(queries, "Query list");
        for (Query query : queries) {
            Args.notNull(query, "query");
        }
        Args.notNull(this.getSchedule(), "schedule");
    }
}

