/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mcp.server.handler;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.loadbalancer.cache.UpstreamCacheManager;
import org.apache.shenyu.plugin.base.cache.CommonHandleCache;
import org.apache.shenyu.plugin.base.cache.MetaDataCache;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.BeanHolder;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.mcp.server.manager.ShenyuMcpServerManager;
import org.apache.shenyu.plugin.mcp.server.model.McpServerToolParameter;
import org.apache.shenyu.plugin.mcp.server.model.ShenyuMcpServer;
import org.apache.shenyu.plugin.mcp.server.model.ShenyuMcpServerTool;
import org.apache.shenyu.plugin.mcp.server.utils.JsonSchemaUtil;
import org.springframework.ai.util.json.schema.JsonSchemaGenerator;

public class McpServerPluginDataHandler
implements PluginDataHandler {
    public static final Supplier<CommonHandleCache<String, ShenyuMcpServer>> CACHED_SERVER = new BeanHolder(CommonHandleCache::new);
    public static final Supplier<CommonHandleCache<String, ShenyuMcpServerTool>> CACHED_TOOL = new BeanHolder(CommonHandleCache::new);
    private static final String DEFAULT_MESSAGE_ENDPOINT = "{\"messageEndpoint\":\"/message\"}";
    private static final String SLASH = "/";
    private static final String STAR = "/**";
    private final ShenyuMcpServerManager shenyuMcpServerManager;

    public McpServerPluginDataHandler(ShenyuMcpServerManager shenyuMcpServerManager) {
        this.shenyuMcpServerManager = shenyuMcpServerManager;
    }

    public void handlerSelector(SelectorData selectorData) {
        if (Objects.isNull(selectorData) || Objects.isNull(selectorData.getId())) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)selectorData.getConditionList())) {
            return;
        }
        String uri = selectorData.getConditionList().stream().filter(condition -> "uri".equals(condition.getParamType())).map(ConditionData::getParamValue).findFirst().orElse(null);
        String path = StringUtils.removeEnd((String)uri, (String)SLASH);
        path = StringUtils.removeEnd((String)path, (String)STAR);
        ShenyuMcpServer shenyuMcpServer = (ShenyuMcpServer)GsonUtils.getInstance().fromJson(StringUtils.isBlank((CharSequence)selectorData.getHandle()) ? DEFAULT_MESSAGE_ENDPOINT : selectorData.getHandle(), ShenyuMcpServer.class);
        shenyuMcpServer.setPath(path);
        CACHED_SERVER.get().cachedHandle((Object)selectorData.getId(), (Object)shenyuMcpServer);
        String messageEndpoint = shenyuMcpServer.getMessageEndpoint();
        if (StringUtils.isNotBlank((CharSequence)uri) && !this.shenyuMcpServerManager.hasMcpServer(uri)) {
            this.shenyuMcpServerManager.getOrCreateMcpServerTransport(uri, messageEndpoint);
        }
        MetaDataCache.getInstance().clean();
    }

    public void removeSelector(SelectorData selectorData) {
        UpstreamCacheManager.getInstance().removeByKey(selectorData.getId());
        MetaDataCache.getInstance().clean();
        CACHED_TOOL.get().removeHandle((Object)CacheKeyUtils.INST.getKey(selectorData.getId(), "default_rule"));
        String uri = selectorData.getHandle();
        if (StringUtils.isBlank((CharSequence)uri)) {
            uri = selectorData.getConditionList().stream().filter(condition -> "uri".equals(condition.getParamType())).map(ConditionData::getParamValue).findFirst().orElse(null);
        }
        CACHED_SERVER.get().removeHandle((Object)selectorData.getId());
        if (StringUtils.isNotBlank((CharSequence)uri) && this.shenyuMcpServerManager.hasMcpServer(uri)) {
            this.shenyuMcpServerManager.removeMcpServer(uri);
        }
    }

    public void handlerRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> {
            ShenyuMcpServerTool mcpServerTool = (ShenyuMcpServerTool)GsonUtils.getInstance().fromJson(s, ShenyuMcpServerTool.class);
            CACHED_TOOL.get().cachedHandle((Object)CacheKeyUtils.INST.getKey(ruleData), (Object)mcpServerTool);
            MetaDataCache.getInstance().clean();
            List<McpServerToolParameter> parameters = mcpServerTool.getParameters();
            String inputSchema = JsonSchemaUtil.createParameterSchema(parameters, new JsonSchemaGenerator.SchemaOption[0]);
            ShenyuMcpServer server = (ShenyuMcpServer)CACHED_SERVER.get().obtainHandle((Object)ruleData.getSelectorId());
            if (Objects.nonNull(server)) {
                this.shenyuMcpServerManager.addTool(server.getPath(), StringUtils.isBlank((CharSequence)mcpServerTool.getName()) ? ruleData.getName() : mcpServerTool.getName(), mcpServerTool.getDescription(), mcpServerTool.getRequestConfig(), inputSchema);
            }
        });
    }

    public void removeRule(RuleData ruleData) {
        Optional.ofNullable(ruleData.getHandle()).ifPresent(s -> {
            CACHED_TOOL.get().removeHandle((Object)CacheKeyUtils.INST.getKey(ruleData));
            ShenyuMcpServer server = (ShenyuMcpServer)CACHED_SERVER.get().obtainHandle((Object)ruleData.getSelectorId());
            this.shenyuMcpServerManager.removeTool(server.getPath(), ruleData.getName());
        });
        MetaDataCache.getInstance().clean();
    }

    public String pluginNamed() {
        return PluginEnum.MCP_SERVER.getName();
    }
}

