/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.xml;

import jakarta.xml.bind.JAXBException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.OpenOption;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Filter;
import java.util.logging.LogRecord;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.sis.referencing.internal.shared.DefinitionVerifier;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.StorageConnector;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.storage.base.MetadataBuilder;
import org.apache.sis.storage.base.URIDataStore;
import org.apache.sis.storage.event.WarningEvent;
import org.apache.sis.storage.xml.StoreProvider;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.XML;
import org.apache.sis.xml.internal.shared.URISource;
import org.opengis.metadata.Metadata;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

final class Store
extends URIDataStore
implements Filter {
    private volatile StreamSource source;
    private Object object;
    private Metadata metadata;

    public Store(StoreProvider provider, StorageConnector connector) throws URISyntaxException, DataStoreException {
        super(provider, connector);
        InputStream in = connector.getStorageAs(InputStream.class);
        if (in != null) {
            this.source = URISource.create((InputStream)in, (URI)this.location);
        } else {
            Reader reader = connector.getStorageAs(Reader.class);
            if (reader != null) {
                StreamSource s = URISource.create(null, (URI)this.location);
                s.setReader(reader);
                this.source = s;
            }
        }
        Closeable c = Store.input(this.source);
        connector.closeAllExcept(c);
        if (c == null) {
            throw new UnsupportedStorageException(super.getLocale(), "XML", connector.getStorage(), (OpenOption[])connector.getOption(OptionKey.OPEN_OPTIONS));
        }
        this.listeners.useReadOnlyEvents();
    }

    private static Closeable input(StreamSource source) {
        Closeable in = null;
        if (source != null && (in = source.getInputStream()) == null) {
            in = source.getReader();
        }
        return in;
    }

    private Map<String, ?> properties() {
        if (this.listeners.hasListeners(WarningEvent.class)) {
            return Map.of("org.apache.sis.xml.warningFilter", this);
        }
        return null;
    }

    @Override
    public boolean isLoggable(LogRecord warning) {
        warning.setLoggerName("org.apache.sis.xml");
        this.listeners.warning(warning);
        return false;
    }

    private void unmarshal() throws DataStoreException {
        StreamSource s = this.source;
        Closeable in = Store.input(s);
        if (in != null) {
            try {
                try {
                    this.object = XML.unmarshal((Source)s, this.properties());
                }
                finally {
                    this.source = null;
                    in.close();
                }
            }
            catch (JAXBException | IOException e) {
                throw new DataStoreException(Errors.format((short)19, (Object)this.getDisplayName()), e);
            }
        }
        if (this.object instanceof CoordinateReferenceSystem) {
            try {
                DefinitionVerifier v = DefinitionVerifier.withAuthority((CoordinateReferenceSystem)((CoordinateReferenceSystem)this.object), null, (boolean)false, (Locale)this.getLocale());
                if (v != null) {
                    this.log(v.warning(false));
                }
            }
            catch (FactoryException e) {
                this.listeners.warning((Exception)((Object)e));
            }
        }
    }

    private void log(LogRecord record) {
        if (record != null) {
            record.setSourceClassName(Store.class.getName());
            record.setSourceMethodName("getMetadata");
            record.setLoggerName("org.apache.sis.xml");
            this.listeners.warning(record);
        }
    }

    @Override
    public synchronized Metadata getMetadata() throws DataStoreException {
        if (this.metadata == null) {
            this.unmarshal();
            if (this.object instanceof Metadata) {
                this.metadata = (Metadata)this.object;
            } else if (this.object instanceof ReferenceSystem) {
                MetadataBuilder builder = new MetadataBuilder();
                builder.addReferenceSystem((ReferenceSystem)this.object);
                builder.addTitle(this.getDisplayName());
                this.mergeAuxiliaryMetadata(Store.class, builder);
                this.metadata = builder.buildAndFreeze();
            }
        }
        return this.metadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws DataStoreException {
        try {
            this.listeners.close();
            AutoCloseable in = Store.input(this.source);
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            throw new DataStoreException(e);
        }
        finally {
            Store store = this;
            synchronized (store) {
                this.object = null;
                this.source = null;
            }
        }
    }
}

