/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.cs.CoordinateSystemAxis;

final class AxisName {
    private static final AxisName[] KEYWORDS = new AxisName[]{new AxisName(".*\\blatitudes?\\b.*", 112), new AxisName(".*\\blongitudes?\\b.*", 122), new AxisName(".*\\bheights?\\b.*", 98), new AxisName(".*\\btimes?\\b.*", 195)};
    private final Pattern pattern;
    private final short word;

    private AxisName(String regex, short word) {
        this.pattern = Pattern.compile(regex, 2);
        this.word = word;
    }

    static String find(CoordinateSystemAxis axis, Locale locale) {
        String name = IdentifiedObjects.getName((IdentifiedObject)axis, null);
        if (name != null) {
            for (AxisName keyword : KEYWORDS) {
                if (!keyword.pattern.matcher(name).matches()) continue;
                return Vocabulary.forLocale((Locale)locale).getString(keyword.word);
            }
        }
        return IdentifiedObjects.getDisplayName((IdentifiedObject)axis, locale);
    }
}

