/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.util.List;
import javax.measure.IncommensurableException;
import org.apache.sis.parameter.Parameterized;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.CoordinateSystems;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.shared.CoordinateOperations;
import org.apache.sis.referencing.internal.shared.WKTUtilities;
import org.apache.sis.referencing.operation.provider.Affine;
import org.apache.sis.referencing.operation.transform.CartesianToPolar;
import org.apache.sis.referencing.operation.transform.CartesianToSpherical;
import org.apache.sis.referencing.operation.transform.CoordinateSystemTransform;
import org.apache.sis.referencing.operation.transform.MathTransformBuilder;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.PolarToCartesian;
import org.apache.sis.referencing.operation.transform.SphericalToCartesian;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CylindricalCS;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.PolarCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.util.FactoryException;

final class CoordinateSystemTransformBuilder
extends MathTransformBuilder {
    private CoordinateSystem source;
    private CoordinateSystem target;
    private Ellipsoid ellipsoid;
    private ParameterValueGroup parameters;
    private Parameterized parameterized;
    private byte parametersType;
    private static final byte IDENTITY = 1;
    private static final byte LINEAR = 2;
    private static final byte CONVERSION = 3;

    CoordinateSystemTransformBuilder(MathTransformFactory factory) {
        super(factory);
    }

    @Override
    public void setSourceAxes(CoordinateSystem cs, Ellipsoid ellipsoid) {
        this.setEllipsoid(ellipsoid);
        this.source = cs;
    }

    @Override
    public void setTargetAxes(CoordinateSystem cs, Ellipsoid ellipsoid) {
        this.setEllipsoid(ellipsoid);
        this.target = cs;
    }

    private void setEllipsoid(Ellipsoid value) {
        if (value != null) {
            if (this.ellipsoid != null && !Utilities.equalsIgnoreMetadata((Object)this.ellipsoid, (Object)value)) {
                throw new IllegalStateException(Errors.format((short)1, (Object)"ellipsoid"));
            }
            this.ellipsoid = value;
        }
    }

    @Override
    public ParameterValueGroup parameters() {
        if (this.parameters == null) {
            if (this.parameterized != null) {
                this.parameters = this.parameterized.getParameterValues();
            }
            if (this.parameters == null) {
                OperationMethod method = this.provider;
                if (method == null) {
                    method = Affine.provider();
                }
                this.parameters = method.getParameters().createValue();
            }
        }
        return this.parameters;
    }

    @Override
    public MathTransform create() throws FactoryException {
        if (this.source == null || this.target == null) {
            throw new IllegalStateException(Errors.format((short)111, (Object)(this.source == null ? "source" : "target")));
        }
        List<CoordinateSystem> sources = CoordinateSystems.getSingleComponents(this.source);
        List<CoordinateSystem> targets = CoordinateSystems.getSingleComponents(this.target);
        int count = sources.size();
        MathTransform result = null;
        if (count == targets.size()) {
            int dimension = this.source.getDimension();
            int firstAffectedCoordinate = 0;
            for (int i = 0; i < count; ++i) {
                MathTransform step;
                CoordinateSystem stepSource = sources.get(i);
                CoordinateSystem stepTarget = targets.get(i);
                int sourceDim = stepSource.getDimension();
                if (stepTarget.getDimension() != sourceDim) {
                    result = null;
                    break;
                }
                try {
                    step = this.single(stepSource, stepTarget);
                }
                catch (IllegalArgumentException | IncommensurableException e) {
                    throw new OperationNotFoundException(CoordinateSystemTransformBuilder.operationNotFound(stepSource, stepTarget), e);
                }
                int numTrailingCoordinates = dimension - (firstAffectedCoordinate + sourceDim);
                step = this.factory.createPassThroughTransform(firstAffectedCoordinate, step, numTrailingCoordinates);
                result = result == null ? step : this.factory.createConcatenatedTransform(result, step);
                firstAffectedCoordinate += sourceDim;
            }
        }
        if (result == null) {
            try {
                result = this.single(this.source, this.target);
            }
            catch (IllegalArgumentException | IncommensurableException e) {
                throw new OperationNotFoundException(CoordinateSystemTransformBuilder.operationNotFound(this.source, this.target), e);
            }
        }
        return this.unique(result);
    }

    private MathTransform single(CoordinateSystem stepSource, CoordinateSystem stepTarget) throws FactoryException, IncommensurableException {
        MathTransform normalized;
        MathTransform result;
        Affine method;
        if (this.ellipsoid != null) {
            if (stepSource instanceof EllipsoidalCS) {
                if (stepTarget instanceof EllipsoidalCS) {
                    return this.addOrRemoveVertical(stepSource, stepTarget, "Geographic2D to 3D conversion", "Geographic3D to 2D conversion");
                }
                if (stepTarget instanceof CartesianCS || stepTarget instanceof SphericalCS) {
                    MathTransformBuilder context = CoordinateOperations.builder(this.factory, "Ellipsoid_To_Geocentric");
                    context.setSourceAxes(stepSource, this.ellipsoid);
                    context.setTargetAxes(stepTarget, null);
                    return this.delegate(context);
                }
            } else if (stepTarget instanceof EllipsoidalCS) {
                if (stepSource instanceof CartesianCS || stepSource instanceof SphericalCS) {
                    MathTransformBuilder context = CoordinateOperations.builder(this.factory, "Geocentric_To_Ellipsoid");
                    context.setSourceAxes(stepSource, null);
                    context.setTargetAxes(stepTarget, this.ellipsoid);
                    return this.delegate(context);
                }
            } else if (stepSource instanceof SphericalCS && stepTarget instanceof SphericalCS) {
                return this.addOrRemoveVertical(stepSource, stepTarget, "Spherical2D to 3D conversion", "Spherical3D to 2D conversion");
            }
        }
        int passthrough = 0;
        CoordinateSystemTransform kernel = null;
        if (stepSource instanceof CartesianCS) {
            if (stepTarget instanceof SphericalCS) {
                kernel = CartesianToSpherical.INSTANCE;
            } else if (stepTarget instanceof PolarCS) {
                kernel = CartesianToPolar.INSTANCE;
            } else if (stepTarget instanceof CylindricalCS) {
                kernel = CartesianToPolar.INSTANCE;
                passthrough = 1;
            }
        } else if (stepTarget instanceof CartesianCS) {
            if (stepSource instanceof SphericalCS) {
                kernel = SphericalToCartesian.INSTANCE;
            } else if (stepSource instanceof PolarCS) {
                kernel = PolarToCartesian.INSTANCE;
            } else if (stepSource instanceof CylindricalCS) {
                kernel = PolarToCartesian.INSTANCE;
                passthrough = 1;
            }
        }
        if (kernel == null) {
            method = Affine.provider();
            normalized = result = this.factory.createAffineTransform(CoordinateSystems.swapAndScaleAxes(stepSource, stepTarget));
        } else {
            if (stepSource.getDimension() != kernel.getSourceDimensions() + passthrough || stepTarget.getDimension() != kernel.getTargetDimensions() + passthrough) {
                throw new OperationNotFoundException(CoordinateSystemTransformBuilder.operationNotFound(stepSource, stepTarget));
            }
            if (passthrough == 0) {
                method = kernel.method;
                normalized = kernel.completeTransform(this.factory);
            } else {
                method = kernel.method3D;
                normalized = kernel.passthrough(this.factory);
            }
            MathTransform before = this.factory.createAffineTransform(CoordinateSystems.swapAndScaleAxes(stepSource, CoordinateSystems.replaceAxes(stepSource, AxesConvention.NORMALIZED)));
            MathTransform after = this.factory.createAffineTransform(CoordinateSystems.swapAndScaleAxes(CoordinateSystems.replaceAxes(stepTarget, AxesConvention.NORMALIZED), stepTarget));
            result = this.factory.createConcatenatedTransform(before, this.factory.createConcatenatedTransform(normalized, after));
        }
        this.setParameters(normalized, method, null);
        return result;
    }

    private MathTransform addOrRemoveVertical(CoordinateSystem stepSource, CoordinateSystem stepTarget, String add, String remove) throws FactoryException, IncommensurableException {
        int change = stepTarget.getDimension() - stepSource.getDimension();
        if (change != 0) {
            String method = change < 0 ? remove : add;
            MathTransformBuilder context = CoordinateOperations.builder(this.factory, method);
            context.setSourceAxes(stepSource, this.ellipsoid);
            context.setTargetAxes(stepTarget, this.ellipsoid);
            return this.delegate(context);
        }
        MathTransform step = this.factory.createAffineTransform(CoordinateSystems.swapAndScaleAxes(stepSource, stepTarget));
        this.setParameters(step, Affine.provider(), null);
        return step;
    }

    private MathTransform delegate(MathTransformBuilder context) throws FactoryException {
        MathTransform step = context.create();
        this.setParameters(step, context.getMethod().orElse(null), context.parameters());
        return step;
    }

    private void setParameters(MathTransform result, OperationMethod method, ParameterValueGroup values) {
        byte type = result.isIdentity() ? (byte)1 : (MathTransforms.isLinear(result) ? (byte)2 : 3);
        if (this.parametersType < type) {
            this.parametersType = type;
            this.provider = method;
            this.parameters = values;
            if (result instanceof Parameterized) {
                this.parameterized = (Parameterized)result;
            }
        }
    }

    private static String operationNotFound(CoordinateSystem stepSource, CoordinateSystem stepTarget) {
        return Resources.format((short)13, WKTUtilities.toType(CoordinateSystem.class, stepSource.getClass()), WKTUtilities.toType(CoordinateSystem.class, stepTarget.getClass()));
    }
}

