/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.gpx;

import jakarta.xml.bind.annotation.XmlAttribute;
import org.apache.sis.storage.xml.GeographicEnvelope;
import org.opengis.metadata.extent.GeographicBoundingBox;

public final class Bounds
extends GeographicEnvelope {
    @XmlAttribute(name="minlon", required=true)
    public double westBoundLongitude = Double.NaN;
    @XmlAttribute(name="maxlon", required=true)
    public double eastBoundLongitude = Double.NaN;
    @XmlAttribute(name="minlat", required=true)
    public double southBoundLatitude = Double.NaN;
    @XmlAttribute(name="maxlat", required=true)
    public double northBoundLatitude = Double.NaN;

    public Bounds() {
    }

    private Bounds(GeographicBoundingBox box) {
        this.westBoundLongitude = box.getWestBoundLongitude();
        this.eastBoundLongitude = box.getEastBoundLongitude();
        this.northBoundLatitude = box.getNorthBoundLatitude();
        this.southBoundLatitude = box.getSouthBoundLatitude();
    }

    public static Bounds castOrCopy(GeographicBoundingBox box) {
        return box == null || box instanceof Bounds ? (Bounds)box : new Bounds(box);
    }

    public double getWestBoundLongitude() {
        return this.westBoundLongitude;
    }

    public double getEastBoundLongitude() {
        return this.eastBoundLongitude;
    }

    public double getSouthBoundLatitude() {
        return this.southBoundLatitude;
    }

    public double getNorthBoundLatitude() {
        return this.northBoundLatitude;
    }
}

