/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.gazetteer;

import jakarta.xml.bind.annotation.XmlTransient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.iso.extent.Extents;
import org.apache.sis.referencing.AbstractReferenceSystem;
import org.apache.sis.referencing.ImmutableIdentifier;
import org.apache.sis.referencing.gazetteer.AbstractLocation;
import org.apache.sis.referencing.gazetteer.AbstractLocationType;
import org.apache.sis.referencing.gazetteer.ModifiableLocationType;
import org.apache.sis.referencing.gazetteer.ModifiableLocationTypeAdapter;
import org.apache.sis.referencing.internal.shared.WKTUtilities;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

@XmlTransient
public abstract class ReferencingByIdentifiers
extends AbstractReferenceSystem {
    public static final String THEME_KEY = "theme";
    public static final String OVERALL_OWNER_KEY = "overallOwner";
    private static final long serialVersionUID = 5353942546043471933L;
    static final Logger LOGGER = Logger.getLogger("org.apache.sis.referencing.gazetteer");
    private final InternationalString theme;
    private final AbstractParty overallOwner;
    final List<AbstractLocationType> locationTypes;

    public ReferencingByIdentifiers(Map<String, ?> properties, ModifiableLocationType ... types) {
        super(properties);
        this.theme = Types.toInternationalString(properties, (String)THEME_KEY);
        this.overallOwner = (AbstractParty)Containers.property(properties, (Object)OVERALL_OWNER_KEY, AbstractParty.class);
        this.locationTypes = AbstractLocationType.snapshot(this, types);
    }

    static Map<String, Object> properties(Object name, String id, AbstractParty party) {
        HashMap<String, Object> properties = new HashMap<String, Object>(8);
        properties.put("name", name);
        properties.put("identifiers", new ImmutableIdentifier(Citations.SIS, "SIS", id));
        properties.put("domainOfValidity", Extents.WORLD);
        properties.put(THEME_KEY, Vocabulary.formatInternational((short)126));
        properties.put(OVERALL_OWNER_KEY, party);
        return properties;
    }

    public InternationalString getTheme() {
        return this.theme;
    }

    public AbstractParty getOverallOwner() {
        return this.overallOwner;
    }

    public List<? extends ModifiableLocationType> getLocationTypes() {
        return ModifiableLocationTypeAdapter.copy(this.locationTypes);
    }

    final AbstractLocationType rootType() {
        return this.locationTypes.get(0);
    }

    public abstract Coder createCoder();

    public boolean equals(Object object, ComparisonMode mode) {
        ReferencingByIdentifiers that;
        if (!super.equals(object, mode)) {
            return false;
        }
        switch (mode) {
            case STRICT: {
                ReferencingByIdentifiers that2 = (ReferencingByIdentifiers)((Object)object);
                return Objects.equals(this.theme, that2.theme) && Objects.equals(this.overallOwner, that2.overallOwner) && this.locationTypes.equals(that2.locationTypes);
            }
            case BY_CONTRACT: {
                that = (ReferencingByIdentifiers)((Object)object);
                if (Utilities.deepEquals((Object)this.getTheme(), (Object)that.getTheme(), (ComparisonMode)mode) && Utilities.deepEquals((Object)this.getOverallOwner(), (Object)that.getOverallOwner(), (ComparisonMode)mode)) break;
                return false;
            }
        }
        that = (ReferencingByIdentifiers)((Object)object);
        return Utilities.deepEquals(this.locationTypes, that.locationTypes, (ComparisonMode)mode);
    }

    protected long computeHashCode() {
        return super.computeHashCode() + (long)Objects.hash(this.theme, this.overallOwner, this.locationTypes);
    }

    protected String formatTo(Formatter formatter) {
        WKTUtilities.appendName((IdentifiedObject)this, (Formatter)formatter, (ElementKind)ElementKind.NAME);
        if (this.theme != null) {
            formatter.newLine();
            formatter.append((FormattableObject)new SubElement("Theme", this.theme));
        }
        if (this.overallOwner != null) {
            formatter.newLine();
            formatter.append((FormattableObject)new SubElement("Owner", this.overallOwner.getName()));
        }
        for (AbstractLocationType type : this.locationTypes) {
            formatter.newLine();
            formatter.append((FormattableObject)new SubElement("LocationType", type.getName()));
        }
        return "ReferenceSystemUsingIdentifiers";
    }

    private static final class SubElement
    extends FormattableObject {
        private final String name;
        private final InternationalString value;

        SubElement(String name, InternationalString value) {
            this.name = name;
            this.value = value;
        }

        protected String formatTo(Formatter formatter) {
            formatter.append(this.value != null ? this.value.toString(formatter.getLocale()) : null, null);
            return this.name;
        }
    }

    public static abstract class Coder {
        protected Coder() {
        }

        public abstract ReferencingByIdentifiers getReferenceSystem();

        public abstract Quantity<?> getPrecision(DirectPosition var1);

        public abstract void setPrecision(Quantity<?> var1, DirectPosition var2) throws IncommensurableException;

        public String encode(DirectPosition position, Quantity<?> precision) throws IncommensurableException, TransformException {
            this.setPrecision(precision, position);
            return this.encode(position);
        }

        public abstract String encode(DirectPosition var1) throws TransformException;

        public abstract AbstractLocation decode(CharSequence var1) throws TransformException;

        static void recoverableException(Class<?> caller, String method, Exception e) {
            Logging.recoverableException((Logger)LOGGER, caller, (String)method, (Throwable)e);
        }
    }
}

