/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.ClientTlsConfig;
import com.linecorp.armeria.common.AbstractTlsConfigBuilder;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@UnstableApi
public final class ClientTlsConfigBuilder
extends AbstractTlsConfigBuilder<ClientTlsConfigBuilder> {
    private boolean tlsNoVerifySet;
    private final Set<String> insecureHosts = new HashSet<String>();

    ClientTlsConfigBuilder() {
    }

    public ClientTlsConfigBuilder tlsNoVerify() {
        this.tlsNoVerifySet = true;
        Preconditions.checkState(this.insecureHosts.isEmpty(), "tlsNoVerify() and tlsNoVerifyHosts() are mutually exclusive.");
        return this;
    }

    public ClientTlsConfigBuilder tlsNoVerifyHosts(String ... insecureHosts) {
        Objects.requireNonNull(insecureHosts, "insecureHosts");
        return this.tlsNoVerifyHosts(ImmutableList.copyOf(insecureHosts));
    }

    public ClientTlsConfigBuilder tlsNoVerifyHosts(Iterable<String> insecureHosts) {
        Objects.requireNonNull(insecureHosts, "insecureHosts");
        Preconditions.checkState(!this.tlsNoVerifySet, "tlsNoVerify() and tlsNoVerifyHosts() are mutually exclusive.");
        insecureHosts.forEach(this.insecureHosts::add);
        return this;
    }

    public ClientTlsConfig build() {
        return new ClientTlsConfig(this.allowsUnsafeCiphers(), this.meterIdPrefix(), this.tlsCustomizer(), this.tlsNoVerifySet, ImmutableSet.copyOf(this.insecureHosts));
    }
}

