/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.promql.rt;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.skywalking.mqe.rt.operation.aggregatelabels.AggregateLabelsFunc;
import org.apache.skywalking.mqe.rt.operation.aggregatelabels.AggregateLabelsFuncFactory;
import org.apache.skywalking.mqe.rt.operation.aggregatelabels.AvgAggregateLabelsFunc;
import org.apache.skywalking.mqe.rt.operation.aggregatelabels.MaxAggregateLabelsFunc;
import org.apache.skywalking.mqe.rt.operation.aggregatelabels.MinAggregateLabelsFunc;
import org.apache.skywalking.mqe.rt.operation.aggregatelabels.SumAggregateLabelsFunc;
import org.apache.skywalking.oap.query.promql.entity.LabelValuePair;
import org.apache.skywalking.oap.query.promql.entity.MetricInfo;
import org.apache.skywalking.oap.query.promql.entity.MetricRangeData;
import org.apache.skywalking.oap.query.promql.entity.TimeValuePair;
import org.apache.skywalking.oap.query.promql.rt.exception.IllegalExpressionException;
import org.apache.skywalking.oap.query.promql.rt.result.MetricsRangeResult;
import org.apache.skywalking.oap.query.promql.rt.result.ParseResultType;
import org.apache.skywalking.oap.query.promql.rt.result.ScalarResult;
import org.apache.skywalking.oap.server.core.query.DurationUtils;
import org.apache.skywalking.oap.server.core.query.PointOfTime;
import org.apache.skywalking.oap.server.core.query.type.KVInt;
import org.apache.skywalking.oap.server.core.query.type.MetricsValues;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.joda.time.Duration;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class PromOpUtils {
    static MetricsRangeResult matrixScalarBinaryOp(MetricsRangeResult matrix, ScalarResult scalar, int opType) {
        MetricsRangeResult result = new MetricsRangeResult();
        result.setResultType(ParseResultType.METRICS_RANGE);
        result.setRangeExpression(matrix.isRangeExpression());
        matrix.getMetricDataList().forEach(metricData -> {
            MetricRangeData newData = new MetricRangeData();
            result.getMetricDataList().add(newData);
            newData.setMetric(metricData.getMetric());
            List<TimeValuePair> newValues = metricData.getValues().stream().map(value -> {
                double v = Double.parseDouble(value.getValue());
                return new TimeValuePair(value.getTime(), PromOpUtils.formatDoubleValue(PromOpUtils.scalarBinaryOp(v, scalar.getValue(), opType)));
            }).collect(Collectors.toList());
            newData.setValues(newValues);
        });
        return result;
    }

    static MetricsRangeResult matrixBinaryOp(MetricsRangeResult matrixLeft, MetricsRangeResult matrixRight, int opType) throws IllegalExpressionException {
        MetricsRangeResult result = new MetricsRangeResult();
        result.setResultType(ParseResultType.METRICS_RANGE);
        result.setRangeExpression(matrixLeft.isRangeExpression());
        for (int i = 0; i < matrixLeft.getMetricDataList().size(); ++i) {
            MetricRangeData dataLeft = matrixLeft.getMetricDataList().get(i);
            MetricRangeData dataRight = matrixRight.getMetricDataList().get(i);
            if (!dataLeft.getMetric().getLabels().equals(dataRight.getMetric().getLabels())) {
                throw new IllegalExpressionException("The metric info result left in conformity with right.");
            }
            if (dataLeft.getValues().size() != dataRight.getValues().size()) {
                throw new IllegalExpressionException("The metric value range left in conformity with right.");
            }
            MetricRangeData newData = new MetricRangeData();
            result.getMetricDataList().add(newData);
            newData.setMetric(dataLeft.getMetric());
            ArrayList<TimeValuePair> newValues = new ArrayList<TimeValuePair>();
            newData.setValues(newValues);
            for (int j = 0; j < dataLeft.getValues().size(); ++j) {
                double lv = Double.parseDouble(dataLeft.getValues().get(j).getValue());
                double rv = Double.parseDouble(dataRight.getValues().get(j).getValue());
                newValues.add(new TimeValuePair(dataLeft.getValues().get(j).getTime(), PromOpUtils.formatDoubleValue(PromOpUtils.scalarBinaryOp(lv, rv, opType))));
            }
        }
        return result;
    }

    static MetricsRangeResult matrixAggregateOp(MetricsRangeResult result, int funcType, List<String> groupingBy) {
        List<MetricRangeData> metricDataList = result.getMetricDataList();
        Map groupedResult = metricDataList.stream().collect(Collectors.groupingBy(rangeData -> PromOpUtils.getLabels(groupingBy, rangeData), LinkedHashMap::new, Collectors.toList()));
        MetricsRangeResult rangeResult = new MetricsRangeResult();
        rangeResult.setResultType(ParseResultType.METRICS_RANGE);
        rangeResult.setRangeExpression(result.isRangeExpression());
        AggregateLabelsFuncFactory factory = PromOpUtils.getAggregateFuncFactory(funcType);
        groupedResult.forEach((labels, dataList) -> {
            if (dataList.isEmpty()) {
                return;
            }
            List<TimeValuePair> combineTo = ((MetricRangeData)dataList.get(0)).getValues();
            for (int i = 0; i < combineTo.size(); ++i) {
                AggregateLabelsFunc aggregateLabelsFunc = factory.getAggregateLabelsFunc();
                for (MetricRangeData rangeData : dataList) {
                    TimeValuePair toCombine = rangeData.getValues().get(i);
                    if (!StringUtil.isNotBlank((String)toCombine.getValue())) continue;
                    aggregateLabelsFunc.combine(Double.valueOf(Double.parseDouble(toCombine.getValue())));
                }
                TimeValuePair timeValuePair = combineTo.get(i);
                Double aggResult = aggregateLabelsFunc.getResult();
                if (aggResult == null) continue;
                timeValuePair.setValue(aggResult.toString());
            }
            MetricRangeData rangeData = new MetricRangeData();
            rangeData.setMetric(new MetricInfo(null));
            rangeData.getMetric().setLabels((List<LabelValuePair>)labels);
            rangeData.setValues(combineTo);
            rangeResult.getMetricDataList().add(rangeData);
        });
        return rangeResult;
    }

    private static AggregateLabelsFuncFactory getAggregateFuncFactory(int funcType) {
        switch (funcType) {
            case 22: {
                return AvgAggregateLabelsFunc::new;
            }
            case 25: {
                return SumAggregateLabelsFunc::new;
            }
            case 23: {
                return MaxAggregateLabelsFunc::new;
            }
            case 24: {
                return MinAggregateLabelsFunc::new;
            }
        }
        throw new IllegalArgumentException("Unsupported aggregate function type: " + funcType);
    }

    private static List<LabelValuePair> getLabels(List<String> groupingBy, MetricRangeData data) {
        return groupingBy.stream().map(labelName -> data.getMetric().getLabels().stream().filter(label -> labelName.equals(label.getLabelName())).findAny().orElseGet(() -> new LabelValuePair((String)labelName, ""))).collect(Collectors.toList());
    }

    static double scalarBinaryOp(double leftValue, double rightValue, int opType) {
        double calculatedResult = 0.0;
        switch (opType) {
            case 12: {
                calculatedResult = leftValue + rightValue;
                break;
            }
            case 11: {
                calculatedResult = leftValue - rightValue;
                break;
            }
            case 13: {
                calculatedResult = leftValue * rightValue;
                break;
            }
            case 14: {
                calculatedResult = leftValue / rightValue;
                break;
            }
            case 15: {
                calculatedResult = leftValue % rightValue;
            }
        }
        return calculatedResult;
    }

    static int scalarCompareOp(double leftValue, double rightValue, int opType) {
        int comparedResult = 0;
        switch (opType) {
            case 16: {
                comparedResult = PromOpUtils.boolToInt(leftValue == rightValue);
                break;
            }
            case 17: {
                comparedResult = PromOpUtils.boolToInt(leftValue != rightValue);
                break;
            }
            case 21: {
                comparedResult = PromOpUtils.boolToInt(leftValue > rightValue);
                break;
            }
            case 19: {
                comparedResult = PromOpUtils.boolToInt(leftValue < rightValue);
                break;
            }
            case 20: {
                comparedResult = PromOpUtils.boolToInt(leftValue >= rightValue);
                break;
            }
            case 18: {
                comparedResult = PromOpUtils.boolToInt(leftValue <= rightValue);
            }
        }
        return comparedResult;
    }

    private static int boolToInt(boolean v) {
        return v ? 1 : 0;
    }

    static MetricsRangeResult matrixScalarCompareOp(MetricsRangeResult matrix, ScalarResult scalar, int opType) {
        MetricsRangeResult result = new MetricsRangeResult();
        result.setResultType(ParseResultType.METRICS_RANGE);
        result.setRangeExpression(matrix.isRangeExpression());
        matrix.getMetricDataList().forEach(metricData -> {
            MetricRangeData newData = new MetricRangeData();
            result.getMetricDataList().add(newData);
            newData.setMetric(metricData.getMetric());
            List<TimeValuePair> newValues = metricData.getValues().stream().filter(timeValuePair -> PromOpUtils.scalarCompareOp(Double.parseDouble(timeValuePair.getValue()), scalar.getValue(), opType) == 1).collect(Collectors.toList());
            newData.setValues(newValues);
        });
        return result;
    }

    static MetricsRangeResult matrixCompareOp(MetricsRangeResult matrixLeft, MetricsRangeResult matrixRight, int opType) throws IllegalExpressionException {
        MetricsRangeResult result = new MetricsRangeResult();
        result.setResultType(ParseResultType.METRICS_RANGE);
        result.setRangeExpression(matrixLeft.isRangeExpression());
        for (int i = 0; i < matrixLeft.getMetricDataList().size(); ++i) {
            MetricRangeData dataLeft = matrixLeft.getMetricDataList().get(i);
            MetricRangeData dataRight = matrixRight.getMetricDataList().get(i);
            if (!dataLeft.getMetric().getLabels().equals(dataRight.getMetric().getLabels())) {
                throw new IllegalExpressionException("The metric info result left in conformity with right.");
            }
            if (dataLeft.getValues().size() != dataRight.getValues().size()) {
                throw new IllegalExpressionException("The metric value range left in conformity with right.");
            }
            MetricRangeData newData = new MetricRangeData();
            result.getMetricDataList().add(newData);
            newData.setMetric(dataLeft.getMetric());
            ArrayList<TimeValuePair> newValues = new ArrayList<TimeValuePair>();
            newData.setValues(newValues);
            for (int j = 0; j < dataLeft.getValues().size(); ++j) {
                double rv;
                double lv = Double.parseDouble(dataLeft.getValues().get(j).getValue());
                if (PromOpUtils.scalarCompareOp(lv, rv = Double.parseDouble(dataRight.getValues().get(j).getValue()), opType) != 1) continue;
                newValues.add(dataLeft.getValues().get(j));
            }
        }
        return result;
    }

    public static List<TimeValuePair> buildMatrixValues(org.apache.skywalking.oap.server.core.query.input.Duration duration, String singleValue) {
        List times = duration.assembleDurationPoints();
        ArrayList<TimeValuePair> values = new ArrayList<TimeValuePair>(times.size());
        for (PointOfTime time : times) {
            long retTimestampSec = DurationUtils.INSTANCE.parseToDateTime(duration.getStep(), time.getPoint()).getMillis() / 1000L;
            TimeValuePair value = new TimeValuePair(retTimestampSec, singleValue);
            values.add(value);
        }
        return values;
    }

    static List<TimeValuePair> buildMatrixValues(org.apache.skywalking.oap.server.core.query.input.Duration duration, MetricsValues metricsValues) {
        List times = duration.assembleDurationPoints();
        ArrayList<TimeValuePair> values = new ArrayList<TimeValuePair>(times.size());
        for (int i = 0; i < times.size(); ++i) {
            long retTimestampSec = DurationUtils.INSTANCE.parseToDateTime(duration.getStep(), ((PointOfTime)times.get(i)).getPoint()).getMillis() / 1000L;
            KVInt kvInt = (KVInt)metricsValues.getValues().getValues().get(i);
            if (kvInt.isEmptyValue()) continue;
            TimeValuePair value = new TimeValuePair(retTimestampSec, Long.toString(kvInt.getValue()));
            values.add(value);
        }
        return values;
    }

    public static String formatDoubleValue(double v) {
        DecimalFormat format = new DecimalFormat("#.##");
        return format.format(v);
    }

    public static Duration formatDuration(String duration) {
        PeriodFormatter f = new PeriodFormatterBuilder().appendWeeks().appendSuffix("w").appendDays().appendSuffix("d").appendHours().appendSuffix("h").appendMinutes().appendSuffix("m").appendSeconds().appendSuffix("s").appendMillis().appendSuffix("ms").toFormatter();
        return f.parsePeriod(duration).toStandardDuration();
    }
}

