/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.graphql.resolver;

import graphql.kickstart.tools.GraphQLQueryResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.skywalking.oap.query.graphql.AsyncQueryUtils;
import org.apache.skywalking.oap.server.core.query.TopologyQueryService;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.type.EndpointTopology;
import org.apache.skywalking.oap.server.core.query.type.ProcessTopology;
import org.apache.skywalking.oap.server.core.query.type.ServiceInstanceTopology;
import org.apache.skywalking.oap.server.core.query.type.Topology;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.library.module.ModuleManager;

public class TopologyQuery
implements GraphQLQueryResolver {
    private final ModuleManager moduleManager;
    private TopologyQueryService queryService;

    public TopologyQuery(ModuleManager moduleManager) {
        this.moduleManager = moduleManager;
    }

    private TopologyQueryService getQueryService() {
        if (this.queryService == null) {
            this.queryService = (TopologyQueryService)this.moduleManager.find("core").provider().getService(TopologyQueryService.class);
        }
        return this.queryService;
    }

    public CompletableFuture<Topology> getGlobalTopology(Duration duration, String layer, boolean debug) {
        return AsyncQueryUtils.queryAsync(() -> {
            DebuggingTraceContext traceContext = new DebuggingTraceContext("Duration: " + duration + ", Layer: " + layer, debug, false);
            DebuggingTraceContext.TRACE_CONTEXT.set(traceContext);
            DebuggingSpan span = traceContext.createSpan("Query global topology");
            try {
                Topology topology = this.getQueryService().getGlobalTopology(duration, layer);
                if (debug) {
                    topology.setDebuggingTrace(traceContext.getExecTrace());
                }
                Topology topology2 = topology;
                return topology2;
            }
            finally {
                traceContext.stopSpan(span);
                traceContext.stopTrace();
                DebuggingTraceContext.TRACE_CONTEXT.remove();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Topology getServiceTopology(String serviceId, Duration duration, boolean debug) {
        DebuggingTraceContext traceContext = new DebuggingTraceContext("ServiceId: " + serviceId + "Duration: " + duration, debug, false);
        DebuggingTraceContext.TRACE_CONTEXT.set(traceContext);
        DebuggingSpan span = traceContext.createSpan("Query service topology");
        try {
            ArrayList<String> selectedServiceList = new ArrayList<String>(1);
            selectedServiceList.add(serviceId);
            Topology topology = this.getServicesTopology(selectedServiceList, duration, debug).join();
            if (debug) {
                topology.setDebuggingTrace(traceContext.getExecTrace());
            }
            Topology topology2 = topology;
            return topology2;
        }
        finally {
            traceContext.stopSpan(span);
            traceContext.stopTrace();
            DebuggingTraceContext.TRACE_CONTEXT.remove();
        }
    }

    public CompletableFuture<Topology> getServicesTopology(List<String> serviceIds, Duration duration, boolean debug) {
        return AsyncQueryUtils.queryAsync(() -> {
            DebuggingTraceContext traceContext = new DebuggingTraceContext("ServiceIds: " + serviceIds + "Duration: " + duration, debug, false);
            DebuggingTraceContext.TRACE_CONTEXT.set(traceContext);
            DebuggingSpan span = traceContext.createSpan("Query service topology");
            try {
                Topology topology = this.getQueryService().getServiceTopology(duration, serviceIds);
                if (debug) {
                    topology.setDebuggingTrace(traceContext.getExecTrace());
                }
                Topology topology2 = topology;
                return topology2;
            }
            finally {
                traceContext.stopSpan(span);
                traceContext.stopTrace();
                DebuggingTraceContext.TRACE_CONTEXT.remove();
            }
        });
    }

    public CompletableFuture<ServiceInstanceTopology> getServiceInstanceTopology(String clientServiceId, String serverServiceId, Duration duration, boolean debug) {
        return AsyncQueryUtils.queryAsync(() -> {
            DebuggingTraceContext traceContext = new DebuggingTraceContext("ClientServiceId: " + clientServiceId + ", ServerServiceId: " + serverServiceId + ", Duration: " + duration, debug, false);
            DebuggingTraceContext.TRACE_CONTEXT.set(traceContext);
            DebuggingSpan span = traceContext.createSpan("Query service instance topology");
            try {
                ServiceInstanceTopology topology = this.getQueryService().getServiceInstanceTopology(clientServiceId, serverServiceId, duration);
                if (debug) {
                    topology.setDebuggingTrace(traceContext.getExecTrace());
                }
                ServiceInstanceTopology serviceInstanceTopology = topology;
                return serviceInstanceTopology;
            }
            finally {
                traceContext.stopSpan(span);
                traceContext.stopTrace();
                DebuggingTraceContext.TRACE_CONTEXT.remove();
            }
        });
    }

    @Deprecated
    public CompletableFuture<Topology> getEndpointTopology(String endpointId, Duration duration) {
        return AsyncQueryUtils.queryAsync(() -> this.getQueryService().getEndpointTopology(duration, endpointId));
    }

    public CompletableFuture<EndpointTopology> getEndpointDependencies(String endpointId, Duration duration, boolean debug) {
        return AsyncQueryUtils.queryAsync(() -> {
            DebuggingTraceContext traceContext = new DebuggingTraceContext("EndpointId: " + endpointId + ", Duration: " + duration, debug, false);
            DebuggingTraceContext.TRACE_CONTEXT.set(traceContext);
            DebuggingSpan span = traceContext.createSpan("Query endpoint dependencies");
            try {
                EndpointTopology topology = this.getQueryService().getEndpointDependencies(duration, endpointId);
                if (debug) {
                    topology.setDebuggingTrace(traceContext.getExecTrace());
                }
                EndpointTopology endpointTopology = topology;
                return endpointTopology;
            }
            finally {
                traceContext.stopSpan(span);
                traceContext.stopTrace();
                DebuggingTraceContext.TRACE_CONTEXT.remove();
            }
        });
    }

    public CompletableFuture<ProcessTopology> getProcessTopology(String instanceId, Duration duration, boolean debug) {
        return AsyncQueryUtils.queryAsync(() -> {
            DebuggingTraceContext traceContext = new DebuggingTraceContext("InstanceId: " + instanceId + ", Duration: " + duration, debug, false);
            DebuggingTraceContext.TRACE_CONTEXT.set(traceContext);
            DebuggingSpan span = traceContext.createSpan("Query process topology");
            try {
                ProcessTopology topology = this.getQueryService().getProcessTopology(instanceId, duration);
                if (debug) {
                    topology.setDebuggingTrace(traceContext.getExecTrace());
                }
                ProcessTopology processTopology = topology;
                return processTopology;
            }
            finally {
                traceContext.stopSpan(span);
                traceContext.stopTrace();
                DebuggingTraceContext.TRACE_CONTEXT.remove();
            }
        });
    }
}

