/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.conditional;

import graphql.Assert;
import graphql.Directives;
import graphql.GraphQLContext;
import graphql.Internal;
import graphql.execution.CoercedVariables;
import graphql.execution.ValuesResolver;
import graphql.execution.conditional.ConditionalNodeDecision;
import graphql.execution.conditional.ConditionalNodeDecisionEnvironment;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.NodeUtil;
import graphql.schema.GraphQLSchema;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@Internal
public class ConditionalNodes {
    public boolean shouldInclude(DirectivesContainer<?> element, Map<String, Object> variables, GraphQLSchema graphQLSchema, GraphQLContext graphQLContext) {
        ConditionalNodeDecision conditionalDecision;
        if (!this.shouldInclude(variables, element.getDirectives())) {
            return false;
        }
        if (graphQLContext != null && (conditionalDecision = (ConditionalNodeDecision)graphQLContext.get(ConditionalNodeDecision.class)) != null) {
            return this.customShouldInclude(variables, element, graphQLSchema, graphQLContext, conditionalDecision);
        }
        return true;
    }

    private boolean customShouldInclude(Map<String, Object> variables, final DirectivesContainer<?> element, final GraphQLSchema graphQLSchema, final GraphQLContext graphQLContext, ConditionalNodeDecision conditionalDecision) {
        final CoercedVariables coercedVariables = CoercedVariables.of(variables);
        return conditionalDecision.shouldInclude(new ConditionalNodeDecisionEnvironment(){

            @Override
            public DirectivesContainer<?> getDirectivesContainer() {
                return element;
            }

            @Override
            public CoercedVariables getVariables() {
                return coercedVariables;
            }

            @Override
            public GraphQLSchema getGraphQlSchema() {
                return graphQLSchema;
            }

            @Override
            public GraphQLContext getGraphQLContext() {
                return graphQLContext;
            }
        });
    }

    private boolean shouldInclude(Map<String, Object> variables, List<Directive> directives) {
        if (directives.isEmpty()) {
            return true;
        }
        boolean skip = this.getDirectiveResult(variables, directives, Directives.SkipDirective.getName(), false);
        if (skip) {
            return false;
        }
        return this.getDirectiveResult(variables, directives, Directives.IncludeDirective.getName(), true);
    }

    private boolean getDirectiveResult(Map<String, Object> variables, List<Directive> directives, String directiveName, boolean defaultValue) {
        Directive foundDirective = NodeUtil.findNodeByName(directives, directiveName);
        if (foundDirective != null) {
            Map<String, Object> argumentValues = ValuesResolver.getArgumentValues(Directives.SkipDirective.getArguments(), foundDirective.getArguments(), CoercedVariables.of(variables), GraphQLContext.getDefault(), Locale.getDefault());
            Object flag = argumentValues.get("if");
            Assert.assertTrue(flag instanceof Boolean, () -> String.format("The '%s' directive MUST have a value for the 'if' argument", directiveName));
            return (Boolean)flag;
        }
        return defaultValue;
    }
}

