/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.GraphQLError;
import graphql.InvalidSyntaxError;
import graphql.PublicApi;
import graphql.language.Definition;
import graphql.language.Document;
import graphql.language.SDLDefinition;
import graphql.parser.InvalidSyntaxException;
import graphql.parser.Parser;
import graphql.parser.ParserEnvironment;
import graphql.parser.ParserOptions;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.errors.NonSDLDefinitionError;
import graphql.schema.idl.errors.SchemaProblem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@PublicApi
public class SchemaParser {
    public TypeDefinitionRegistry parse(File file) throws SchemaProblem {
        try {
            return this.parse(Files.newBufferedReader(file.toPath(), Charset.defaultCharset()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TypeDefinitionRegistry parse(InputStream inputStream) throws SchemaProblem {
        return this.parse(new InputStreamReader(inputStream));
    }

    public TypeDefinitionRegistry parse(Reader reader) throws SchemaProblem {
        return this.parse(reader, null);
    }

    public TypeDefinitionRegistry parse(Reader reader, ParserOptions parserOptions) throws SchemaProblem {
        TypeDefinitionRegistry typeDefinitionRegistry;
        block8: {
            Reader input = reader;
            try {
                typeDefinitionRegistry = this.parseImpl(input, parserOptions);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            input.close();
        }
        return typeDefinitionRegistry;
    }

    public TypeDefinitionRegistry parse(String schemaInput) throws SchemaProblem {
        return this.parseImpl(new StringReader(schemaInput));
    }

    public TypeDefinitionRegistry parseImpl(Reader schemaInput) {
        return this.parseImpl(schemaInput, null);
    }

    private TypeDefinitionRegistry parseImpl(Reader schemaInput, ParserOptions parseOptions) {
        try {
            if (parseOptions == null) {
                parseOptions = ParserOptions.getDefaultSdlParserOptions();
            }
            ParserEnvironment parserEnvironment = ParserEnvironment.newParserEnvironment().document(schemaInput).parserOptions(parseOptions).build();
            Document document = Parser.parse(parserEnvironment);
            return this.buildRegistry(document);
        }
        catch (InvalidSyntaxException e) {
            throw this.handleParseException(e.toInvalidSyntaxError());
        }
    }

    private SchemaProblem handleParseException(InvalidSyntaxError invalidSyntaxError) throws RuntimeException {
        return new SchemaProblem(Collections.singletonList(invalidSyntaxError));
    }

    public TypeDefinitionRegistry buildRegistry(Document document) {
        ArrayList<GraphQLError> errors = new ArrayList<GraphQLError>();
        TypeDefinitionRegistry typeRegistry = new TypeDefinitionRegistry();
        List<Definition> definitions = document.getDefinitions();
        for (Definition definition : definitions) {
            if (definition instanceof SDLDefinition) {
                typeRegistry.add((SDLDefinition)definition).ifPresent(errors::add);
                continue;
            }
            errors.add(new NonSDLDefinitionError(definition));
        }
        if (errors.size() > 0) {
            throw new SchemaProblem(errors);
        }
        return typeRegistry;
    }
}

