/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb;

import org.apache.skywalking.oap.server.core.storage.ttl.MetricsTTL;
import org.apache.skywalking.oap.server.core.storage.ttl.RecordsTTL;
import org.apache.skywalking.oap.server.core.storage.ttl.StorageTTLStatusQuery;
import org.apache.skywalking.oap.server.core.storage.ttl.TTLDefinition;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageConfig;

public class BanyanDBTTLStatusQuery
implements StorageTTLStatusQuery {
    private final int grNormalTTLDays;
    private final int grSuperTTLDays;
    private final int gmMinuteTTLDays;
    private final int gmHourTTLDays;
    private final int gmDayTTLDays;

    public BanyanDBTTLStatusQuery(BanyanDBStorageConfig config) {
        this.grNormalTTLDays = config.getRecordsNormal().getTtl();
        this.grSuperTTLDays = config.getRecordsSuper().getTtl();
        this.gmMinuteTTLDays = config.getMetricsMin().getTtl();
        this.gmHourTTLDays = config.getMetricsHour().getTtl();
        this.gmDayTTLDays = config.getMetricsDay().getTtl();
    }

    public TTLDefinition getTTL() {
        return new TTLDefinition(new MetricsTTL(this.gmMinuteTTLDays, this.gmHourTTLDays, this.gmDayTTLDays), new RecordsTTL(this.grNormalTTLDays, this.grSuperTTLDays));
    }
}

