/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.measure;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.skywalking.banyandb.v1.client.AbstractCriteria;
import org.apache.skywalking.banyandb.v1.client.DataPoint;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.banyandb.v1.client.PairQueryCondition;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.core.hierarchy.instance.InstanceHierarchyRelationTraffic;
import org.apache.skywalking.oap.server.core.hierarchy.service.ServiceHierarchyRelationTraffic;
import org.apache.skywalking.oap.server.core.storage.query.IHierarchyQueryDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBConverter;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageConfig;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;

public class BanyanDBHierarchyQueryDAO
extends AbstractBanyanDBDAO
implements IHierarchyQueryDAO {
    private static final Set<String> SERVICE_HIERARCHY_RELATION_TAGS = ImmutableSet.of((Object)"service_id", (Object)"service_layer", (Object)"related_service_id", (Object)"related_service_layer");
    private static final Set<String> INSTANCE_HIERARCHY_RELATION_TAGS = ImmutableSet.of((Object)"instance_id", (Object)"service_layer", (Object)"related_instance_id", (Object)"related_service_layer");
    private final int limit;

    public BanyanDBHierarchyQueryDAO(BanyanDBStorageClient client, BanyanDBStorageConfig config) {
        super(client);
        this.limit = config.getGlobal().getMetadataQueryMaxSize();
    }

    public List<ServiceHierarchyRelationTraffic> readAllServiceHierarchyRelations() throws Exception {
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata("service_hierarchy_relation", DownSampling.Minute);
        MeasureQueryResponse resp = this.query(schema, SERVICE_HIERARCHY_RELATION_TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                query.limit(BanyanDBHierarchyQueryDAO.this.limit);
            }
        });
        ArrayList<ServiceHierarchyRelationTraffic> relations = new ArrayList<ServiceHierarchyRelationTraffic>();
        for (DataPoint dataPoint : resp.getDataPoints()) {
            relations.add(new ServiceHierarchyRelationTraffic.Builder().storage2Entity((Convert2Entity)new BanyanDBConverter.StorageToMeasure(schema, dataPoint)));
        }
        return relations;
    }

    public List<InstanceHierarchyRelationTraffic> readInstanceHierarchyRelations(String instanceId, String layer) throws Exception {
        MetadataRegistry.Schema schema = MetadataRegistry.INSTANCE.findMetadata("service_hierarchy_relation", DownSampling.Minute);
        MeasureQueryResponse resp = this.query(schema, INSTANCE_HIERARCHY_RELATION_TAGS, Collections.emptySet(), this.buildInstanceRelationsQuery(instanceId, layer));
        ArrayList<InstanceHierarchyRelationTraffic> relations = new ArrayList<InstanceHierarchyRelationTraffic>();
        for (DataPoint dataPoint : resp.getDataPoints()) {
            relations.add(new InstanceHierarchyRelationTraffic.Builder().storage2Entity((Convert2Entity)new BanyanDBConverter.StorageToMeasure(schema, dataPoint)));
        }
        return relations;
    }

    private AbstractBanyanDBDAO.QueryBuilder<MeasureQuery> buildInstanceRelationsQuery(final String instanceId, String layer) {
        final int layerValue = Layer.valueOf((String)layer).value();
        return new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

            @Override
            protected void apply(MeasureQuery query) {
                ArrayList<AbstractCriteria> instanceRelationsQueryConditions = new ArrayList<AbstractCriteria>(2);
                instanceRelationsQueryConditions.add(this.and(Lists.newArrayList((Object[])new PairQueryCondition[]{this.eq("instance_id", instanceId), this.eq("service_layer", layerValue)})));
                instanceRelationsQueryConditions.add(this.and(Lists.newArrayList((Object[])new PairQueryCondition[]{this.eq("related_instance_id", instanceId), this.eq("related_service_layer", layerValue)})));
                query.criteria(this.or(instanceRelationsQueryConditions));
            }
        };
    }
}

