/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.banyandb.measure;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.banyandb.v1.client.DataPoint;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.manual.networkalias.NetworkAddressAlias;
import org.apache.skywalking.oap.server.core.storage.cache.INetworkAddressAliasDAO;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBConverter;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageClient;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.BanyanDBStorageConfig;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.MetadataRegistry;
import org.apache.skywalking.oap.server.storage.plugin.banyandb.stream.AbstractBanyanDBDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanyanDBNetworkAddressAliasDAO
extends AbstractBanyanDBDAO
implements INetworkAddressAliasDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BanyanDBNetworkAddressAliasDAO.class);
    private final NetworkAddressAlias.Builder builder = new NetworkAddressAlias.Builder();
    protected final int limit;
    private MetadataRegistry.Schema schema;
    private static final Set<String> TAGS = ImmutableSet.of((Object)"address", (Object)"last_update_time_bucket", (Object)"represent_service_id", (Object)"represent_service_instance_id");

    public BanyanDBNetworkAddressAliasDAO(BanyanDBStorageClient client, BanyanDBStorageConfig config) {
        super(client);
        this.limit = config.getGlobal().getResultWindowMaxSize();
    }

    private MetadataRegistry.Schema getSchema() {
        if (this.schema == null) {
            this.schema = MetadataRegistry.INSTANCE.findMetadata("network_address_alias", DownSampling.Minute);
        }
        return this.schema;
    }

    public List<NetworkAddressAlias> loadLastUpdate(final long timeBucket) {
        try {
            MeasureQueryResponse resp = this.query(this.getSchema(), TAGS, Collections.emptySet(), new AbstractBanyanDBDAO.QueryBuilder<MeasureQuery>(){

                @Override
                protected void apply(MeasureQuery query) {
                    query.and(this.gte("last_update_time_bucket", timeBucket));
                    query.limit(BanyanDBNetworkAddressAliasDAO.this.limit);
                }
            });
            return resp.getDataPoints().stream().map(point -> this.builder.storage2Entity((Convert2Entity)new BanyanDBConverter.StorageToMeasure(this.getSchema(), (DataPoint)point))).collect(Collectors.toList());
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }
}

