/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.util.Exceptions;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import lombok.Generated;
import org.apache.skywalking.library.elasticsearch.ElasticSearchVersion;
import org.apache.skywalking.library.elasticsearch.response.Index;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AliasClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AliasClient.class);
    private final CompletableFuture<ElasticSearchVersion> version;
    private final WebClient client;

    public Map<String, Index> indices(String name) {
        CompletionStage future = this.version.thenCompose(v -> this.client.execute(v.requestFactory().alias().indices(name)).aggregate().thenApply(response -> {
            HttpStatus status = response.status();
            if (status != HttpStatus.OK) {
                throw new RuntimeException(response.contentUtf8());
            }
            try (HttpData content = response.content();){
                Map<String, Index> map;
                block15: {
                    InputStream is = content.toInputStream();
                    try {
                        map = v.codec().decode(is, new TypeReference<Map<String, Index>>(){});
                        if (is == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return map;
            }
            catch (Exception e) {
                return (Map)Exceptions.throwUnsafely((Throwable)e);
            }
        }));
        ((CompletableFuture)future).whenComplete((result, exception) -> {
            if (exception != null) {
                log.error("Failed to get indices by alias {}.", (Object)name, exception);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Indices by alias {}: {}", (Object)name, result);
            }
        });
        return (Map)((CompletableFuture)future).get();
    }

    @Generated
    public AliasClient(CompletableFuture<ElasticSearchVersion> version, WebClient client) {
        this.version = version;
        this.client = client;
    }
}

