/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.library.elasticsearch.requests.search;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.util.StringUtil;

public final class SearchParams
implements Iterable<Map.Entry<String, Object>> {
    private static final String IGNORE_UNAVAILABLE = "ignore_unavailable";
    private static final String ALLOW_NO_INDICES = "allow_no_indices";
    private static final String EXPAND_WILDCARDS = "expand_wildcards";
    private static final String SCROLL = "scroll";
    private static final String ROUTING = "routing";
    private final Map<String, Object> params = new HashMap<String, Object>();

    public SearchParams ignoreUnavailable(boolean ignoreUnavailable) {
        this.params.put(IGNORE_UNAVAILABLE, ignoreUnavailable);
        return this;
    }

    public SearchParams allowNoIndices(boolean allowNoIndices) {
        this.params.put(ALLOW_NO_INDICES, allowNoIndices);
        return this;
    }

    public SearchParams expandWildcards(String wildcards) {
        this.params.put(EXPAND_WILDCARDS, wildcards);
        return this;
    }

    public SearchParams scroll(Duration contextRetention) {
        Preconditions.checkArgument((contextRetention != null && !contextRetention.isNegative() && !contextRetention.isZero() ? 1 : 0) != 0, (String)"contextRetention must be positive, but was %s", (Object)contextRetention);
        this.params.put(SCROLL, contextRetention.getSeconds() + "s");
        return this;
    }

    public SearchParams routing(String routing) {
        Preconditions.checkArgument((boolean)StringUtil.isNotBlank((String)routing), (Object)"routing must be not blank");
        this.params.put(ROUTING, routing);
        return this;
    }

    public SearchParams routing(Iterable<String> routings) {
        Preconditions.checkArgument((routings != null ? 1 : 0) != 0, (Object)"routing set must be non-null");
        this.routing(String.join((CharSequence)",", routings));
        return this;
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.params.entrySet().iterator();
    }

    @Generated
    public String toString() {
        return "SearchParams(params=" + this.params + ")";
    }
}

