/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.istio.api.networking.v1alpha3.HTTPMatchRequest;
import io.fabric8.istio.api.networking.v1alpha3.HTTPMatchRequestFluent;
import io.fabric8.istio.api.networking.v1alpha3.StringMatch;
import io.fabric8.istio.api.networking.v1alpha3.StringMatchBuilder;
import io.fabric8.istio.api.networking.v1alpha3.StringMatchFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HTTPMatchRequestFluentImpl<A extends HTTPMatchRequestFluent<A>>
extends BaseFluent<A>
implements HTTPMatchRequestFluent<A> {
    private StringMatchBuilder authority;
    private List<String> gateways = new ArrayList<String>();
    private Map<String, StringMatch> headers;
    private Boolean ignoreUriCase;
    private StringMatchBuilder method;
    private String name;
    private Integer port;
    private Map<String, StringMatch> queryParams;
    private StringMatchBuilder scheme;
    private Map<String, String> sourceLabels;
    private String sourceNamespace;
    private StringMatchBuilder uri;
    private Map<String, StringMatch> withoutHeaders;

    public HTTPMatchRequestFluentImpl() {
    }

    public HTTPMatchRequestFluentImpl(HTTPMatchRequest instance) {
        if (instance != null) {
            this.withAuthority(instance.getAuthority());
            this.withGateways(instance.getGateways());
            this.withHeaders(instance.getHeaders());
            this.withIgnoreUriCase(instance.getIgnoreUriCase());
            this.withMethod(instance.getMethod());
            this.withName(instance.getName());
            this.withPort(instance.getPort());
            this.withQueryParams(instance.getQueryParams());
            this.withScheme(instance.getScheme());
            this.withSourceLabels(instance.getSourceLabels());
            this.withSourceNamespace(instance.getSourceNamespace());
            this.withUri(instance.getUri());
            this.withWithoutHeaders(instance.getWithoutHeaders());
        }
    }

    @Override
    @Deprecated
    public StringMatch getAuthority() {
        return this.authority != null ? this.authority.build() : null;
    }

    @Override
    public StringMatch buildAuthority() {
        return this.authority != null ? this.authority.build() : null;
    }

    @Override
    public A withAuthority(StringMatch authority) {
        this._visitables.get((Object)"authority").remove(this.authority);
        if (authority != null) {
            this.authority = new StringMatchBuilder(authority);
            this._visitables.get((Object)"authority").add(this.authority);
        } else {
            this.authority = null;
            this._visitables.get((Object)"authority").remove(this.authority);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAuthority() {
        return this.authority != null;
    }

    @Override
    public HTTPMatchRequestFluent.AuthorityNested<A> withNewAuthority() {
        return new AuthorityNestedImpl();
    }

    @Override
    public HTTPMatchRequestFluent.AuthorityNested<A> withNewAuthorityLike(StringMatch item) {
        return new AuthorityNestedImpl(item);
    }

    @Override
    public HTTPMatchRequestFluent.AuthorityNested<A> editAuthority() {
        return this.withNewAuthorityLike(this.getAuthority());
    }

    @Override
    public HTTPMatchRequestFluent.AuthorityNested<A> editOrNewAuthority() {
        return this.withNewAuthorityLike(this.getAuthority() != null ? this.getAuthority() : new StringMatchBuilder().build());
    }

    @Override
    public HTTPMatchRequestFluent.AuthorityNested<A> editOrNewAuthorityLike(StringMatch item) {
        return this.withNewAuthorityLike(this.getAuthority() != null ? this.getAuthority() : item);
    }

    @Override
    public A addToGateways(int index, String item) {
        if (this.gateways == null) {
            this.gateways = new ArrayList<String>();
        }
        this.gateways.add(index, item);
        return (A)this;
    }

    @Override
    public A setToGateways(int index, String item) {
        if (this.gateways == null) {
            this.gateways = new ArrayList<String>();
        }
        this.gateways.set(index, item);
        return (A)this;
    }

    @Override
    public A addToGateways(String ... items) {
        if (this.gateways == null) {
            this.gateways = new ArrayList<String>();
        }
        for (String item : items) {
            this.gateways.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToGateways(Collection<String> items) {
        if (this.gateways == null) {
            this.gateways = new ArrayList<String>();
        }
        for (String item : items) {
            this.gateways.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGateways(String ... items) {
        for (String item : items) {
            if (this.gateways == null) continue;
            this.gateways.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGateways(Collection<String> items) {
        for (String item : items) {
            if (this.gateways == null) continue;
            this.gateways.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGateways() {
        return this.gateways;
    }

    @Override
    public String getGateway(int index) {
        return this.gateways.get(index);
    }

    @Override
    public String getFirstGateway() {
        return this.gateways.get(0);
    }

    @Override
    public String getLastGateway() {
        return this.gateways.get(this.gateways.size() - 1);
    }

    @Override
    public String getMatchingGateway(Predicate<String> predicate) {
        for (String item : this.gateways) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingGateway(Predicate<String> predicate) {
        for (String item : this.gateways) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withGateways(List<String> gateways) {
        if (gateways != null) {
            this.gateways = new ArrayList<String>();
            for (String item : gateways) {
                this.addToGateways(item);
            }
        } else {
            this.gateways = null;
        }
        return (A)this;
    }

    @Override
    public A withGateways(String ... gateways) {
        if (this.gateways != null) {
            this.gateways.clear();
            this._visitables.remove((Object)"gateways");
        }
        if (gateways != null) {
            for (String item : gateways) {
                this.addToGateways(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGateways() {
        return this.gateways != null && !this.gateways.isEmpty();
    }

    @Override
    public A addToHeaders(String key, StringMatch value) {
        if (this.headers == null && key != null && value != null) {
            this.headers = new LinkedHashMap<String, StringMatch>();
        }
        if (key != null && value != null) {
            this.headers.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToHeaders(Map<String, StringMatch> map) {
        if (this.headers == null && map != null) {
            this.headers = new LinkedHashMap<String, StringMatch>();
        }
        if (map != null) {
            this.headers.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromHeaders(String key) {
        if (this.headers == null) {
            return (A)this;
        }
        if (key != null && this.headers != null) {
            this.headers.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromHeaders(Map<String, StringMatch> map) {
        if (this.headers == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.headers == null) continue;
                this.headers.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, StringMatch> getHeaders() {
        return this.headers;
    }

    @Override
    public <K, V> A withHeaders(Map<String, StringMatch> headers) {
        this.headers = headers == null ? null : new LinkedHashMap<String, StringMatch>(headers);
        return (A)this;
    }

    @Override
    public Boolean hasHeaders() {
        return this.headers != null;
    }

    @Override
    public Boolean getIgnoreUriCase() {
        return this.ignoreUriCase;
    }

    @Override
    public A withIgnoreUriCase(Boolean ignoreUriCase) {
        this.ignoreUriCase = ignoreUriCase;
        return (A)this;
    }

    @Override
    public Boolean hasIgnoreUriCase() {
        return this.ignoreUriCase != null;
    }

    @Override
    @Deprecated
    public StringMatch getMethod() {
        return this.method != null ? this.method.build() : null;
    }

    @Override
    public StringMatch buildMethod() {
        return this.method != null ? this.method.build() : null;
    }

    @Override
    public A withMethod(StringMatch method) {
        this._visitables.get((Object)"method").remove(this.method);
        if (method != null) {
            this.method = new StringMatchBuilder(method);
            this._visitables.get((Object)"method").add(this.method);
        } else {
            this.method = null;
            this._visitables.get((Object)"method").remove(this.method);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMethod() {
        return this.method != null;
    }

    @Override
    public HTTPMatchRequestFluent.MethodNested<A> withNewMethod() {
        return new MethodNestedImpl();
    }

    @Override
    public HTTPMatchRequestFluent.MethodNested<A> withNewMethodLike(StringMatch item) {
        return new MethodNestedImpl(item);
    }

    @Override
    public HTTPMatchRequestFluent.MethodNested<A> editMethod() {
        return this.withNewMethodLike(this.getMethod());
    }

    @Override
    public HTTPMatchRequestFluent.MethodNested<A> editOrNewMethod() {
        return this.withNewMethodLike(this.getMethod() != null ? this.getMethod() : new StringMatchBuilder().build());
    }

    @Override
    public HTTPMatchRequestFluent.MethodNested<A> editOrNewMethodLike(StringMatch item) {
        return this.withNewMethodLike(this.getMethod() != null ? this.getMethod() : item);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public A withPort(Integer port) {
        this.port = port;
        return (A)this;
    }

    @Override
    public Boolean hasPort() {
        return this.port != null;
    }

    @Override
    public A addToQueryParams(String key, StringMatch value) {
        if (this.queryParams == null && key != null && value != null) {
            this.queryParams = new LinkedHashMap<String, StringMatch>();
        }
        if (key != null && value != null) {
            this.queryParams.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToQueryParams(Map<String, StringMatch> map) {
        if (this.queryParams == null && map != null) {
            this.queryParams = new LinkedHashMap<String, StringMatch>();
        }
        if (map != null) {
            this.queryParams.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromQueryParams(String key) {
        if (this.queryParams == null) {
            return (A)this;
        }
        if (key != null && this.queryParams != null) {
            this.queryParams.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromQueryParams(Map<String, StringMatch> map) {
        if (this.queryParams == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.queryParams == null) continue;
                this.queryParams.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, StringMatch> getQueryParams() {
        return this.queryParams;
    }

    @Override
    public <K, V> A withQueryParams(Map<String, StringMatch> queryParams) {
        this.queryParams = queryParams == null ? null : new LinkedHashMap<String, StringMatch>(queryParams);
        return (A)this;
    }

    @Override
    public Boolean hasQueryParams() {
        return this.queryParams != null;
    }

    @Override
    @Deprecated
    public StringMatch getScheme() {
        return this.scheme != null ? this.scheme.build() : null;
    }

    @Override
    public StringMatch buildScheme() {
        return this.scheme != null ? this.scheme.build() : null;
    }

    @Override
    public A withScheme(StringMatch scheme) {
        this._visitables.get((Object)"scheme").remove(this.scheme);
        if (scheme != null) {
            this.scheme = new StringMatchBuilder(scheme);
            this._visitables.get((Object)"scheme").add(this.scheme);
        } else {
            this.scheme = null;
            this._visitables.get((Object)"scheme").remove(this.scheme);
        }
        return (A)this;
    }

    @Override
    public Boolean hasScheme() {
        return this.scheme != null;
    }

    @Override
    public HTTPMatchRequestFluent.SchemeNested<A> withNewScheme() {
        return new SchemeNestedImpl();
    }

    @Override
    public HTTPMatchRequestFluent.SchemeNested<A> withNewSchemeLike(StringMatch item) {
        return new SchemeNestedImpl(item);
    }

    @Override
    public HTTPMatchRequestFluent.SchemeNested<A> editScheme() {
        return this.withNewSchemeLike(this.getScheme());
    }

    @Override
    public HTTPMatchRequestFluent.SchemeNested<A> editOrNewScheme() {
        return this.withNewSchemeLike(this.getScheme() != null ? this.getScheme() : new StringMatchBuilder().build());
    }

    @Override
    public HTTPMatchRequestFluent.SchemeNested<A> editOrNewSchemeLike(StringMatch item) {
        return this.withNewSchemeLike(this.getScheme() != null ? this.getScheme() : item);
    }

    @Override
    public A addToSourceLabels(String key, String value) {
        if (this.sourceLabels == null && key != null && value != null) {
            this.sourceLabels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.sourceLabels.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToSourceLabels(Map<String, String> map) {
        if (this.sourceLabels == null && map != null) {
            this.sourceLabels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.sourceLabels.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromSourceLabels(String key) {
        if (this.sourceLabels == null) {
            return (A)this;
        }
        if (key != null && this.sourceLabels != null) {
            this.sourceLabels.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromSourceLabels(Map<String, String> map) {
        if (this.sourceLabels == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.sourceLabels == null) continue;
                this.sourceLabels.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getSourceLabels() {
        return this.sourceLabels;
    }

    @Override
    public <K, V> A withSourceLabels(Map<String, String> sourceLabels) {
        this.sourceLabels = sourceLabels == null ? null : new LinkedHashMap<String, String>(sourceLabels);
        return (A)this;
    }

    @Override
    public Boolean hasSourceLabels() {
        return this.sourceLabels != null;
    }

    @Override
    public String getSourceNamespace() {
        return this.sourceNamespace;
    }

    @Override
    public A withSourceNamespace(String sourceNamespace) {
        this.sourceNamespace = sourceNamespace;
        return (A)this;
    }

    @Override
    public Boolean hasSourceNamespace() {
        return this.sourceNamespace != null;
    }

    @Override
    @Deprecated
    public StringMatch getUri() {
        return this.uri != null ? this.uri.build() : null;
    }

    @Override
    public StringMatch buildUri() {
        return this.uri != null ? this.uri.build() : null;
    }

    @Override
    public A withUri(StringMatch uri) {
        this._visitables.get((Object)"uri").remove(this.uri);
        if (uri != null) {
            this.uri = new StringMatchBuilder(uri);
            this._visitables.get((Object)"uri").add(this.uri);
        } else {
            this.uri = null;
            this._visitables.get((Object)"uri").remove(this.uri);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUri() {
        return this.uri != null;
    }

    @Override
    public HTTPMatchRequestFluent.UriNested<A> withNewUri() {
        return new UriNestedImpl();
    }

    @Override
    public HTTPMatchRequestFluent.UriNested<A> withNewUriLike(StringMatch item) {
        return new UriNestedImpl(item);
    }

    @Override
    public HTTPMatchRequestFluent.UriNested<A> editUri() {
        return this.withNewUriLike(this.getUri());
    }

    @Override
    public HTTPMatchRequestFluent.UriNested<A> editOrNewUri() {
        return this.withNewUriLike(this.getUri() != null ? this.getUri() : new StringMatchBuilder().build());
    }

    @Override
    public HTTPMatchRequestFluent.UriNested<A> editOrNewUriLike(StringMatch item) {
        return this.withNewUriLike(this.getUri() != null ? this.getUri() : item);
    }

    @Override
    public A addToWithoutHeaders(String key, StringMatch value) {
        if (this.withoutHeaders == null && key != null && value != null) {
            this.withoutHeaders = new LinkedHashMap<String, StringMatch>();
        }
        if (key != null && value != null) {
            this.withoutHeaders.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToWithoutHeaders(Map<String, StringMatch> map) {
        if (this.withoutHeaders == null && map != null) {
            this.withoutHeaders = new LinkedHashMap<String, StringMatch>();
        }
        if (map != null) {
            this.withoutHeaders.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromWithoutHeaders(String key) {
        if (this.withoutHeaders == null) {
            return (A)this;
        }
        if (key != null && this.withoutHeaders != null) {
            this.withoutHeaders.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromWithoutHeaders(Map<String, StringMatch> map) {
        if (this.withoutHeaders == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.withoutHeaders == null) continue;
                this.withoutHeaders.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, StringMatch> getWithoutHeaders() {
        return this.withoutHeaders;
    }

    @Override
    public <K, V> A withWithoutHeaders(Map<String, StringMatch> withoutHeaders) {
        this.withoutHeaders = withoutHeaders == null ? null : new LinkedHashMap<String, StringMatch>(withoutHeaders);
        return (A)this;
    }

    @Override
    public Boolean hasWithoutHeaders() {
        return this.withoutHeaders != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPMatchRequestFluentImpl that = (HTTPMatchRequestFluentImpl)o;
        if (!Objects.equals(this.authority, that.authority)) {
            return false;
        }
        if (!Objects.equals(this.gateways, that.gateways)) {
            return false;
        }
        if (!Objects.equals(this.headers, that.headers)) {
            return false;
        }
        if (!Objects.equals(this.ignoreUriCase, that.ignoreUriCase)) {
            return false;
        }
        if (!Objects.equals(this.method, that.method)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.queryParams, that.queryParams)) {
            return false;
        }
        if (!Objects.equals(this.scheme, that.scheme)) {
            return false;
        }
        if (!Objects.equals(this.sourceLabels, that.sourceLabels)) {
            return false;
        }
        if (!Objects.equals(this.sourceNamespace, that.sourceNamespace)) {
            return false;
        }
        if (!Objects.equals(this.uri, that.uri)) {
            return false;
        }
        return Objects.equals(this.withoutHeaders, that.withoutHeaders);
    }

    public int hashCode() {
        return Objects.hash(this.authority, this.gateways, this.headers, this.ignoreUriCase, this.method, this.name, this.port, this.queryParams, this.scheme, this.sourceLabels, this.sourceNamespace, this.uri, this.withoutHeaders, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authority != null) {
            sb.append("authority:");
            sb.append(this.authority + ",");
        }
        if (this.gateways != null && !this.gateways.isEmpty()) {
            sb.append("gateways:");
            sb.append(this.gateways + ",");
        }
        if (this.headers != null && !this.headers.isEmpty()) {
            sb.append("headers:");
            sb.append(this.headers + ",");
        }
        if (this.ignoreUriCase != null) {
            sb.append("ignoreUriCase:");
            sb.append(this.ignoreUriCase + ",");
        }
        if (this.method != null) {
            sb.append("method:");
            sb.append(this.method + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.queryParams != null && !this.queryParams.isEmpty()) {
            sb.append("queryParams:");
            sb.append(this.queryParams + ",");
        }
        if (this.scheme != null) {
            sb.append("scheme:");
            sb.append(this.scheme + ",");
        }
        if (this.sourceLabels != null && !this.sourceLabels.isEmpty()) {
            sb.append("sourceLabels:");
            sb.append(this.sourceLabels + ",");
        }
        if (this.sourceNamespace != null) {
            sb.append("sourceNamespace:");
            sb.append(this.sourceNamespace + ",");
        }
        if (this.uri != null) {
            sb.append("uri:");
            sb.append(this.uri + ",");
        }
        if (this.withoutHeaders != null && !this.withoutHeaders.isEmpty()) {
            sb.append("withoutHeaders:");
            sb.append(this.withoutHeaders);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withIgnoreUriCase() {
        return this.withIgnoreUriCase(true);
    }

    class UriNestedImpl<N>
    extends StringMatchFluentImpl<HTTPMatchRequestFluent.UriNested<N>>
    implements HTTPMatchRequestFluent.UriNested<N>,
    Nested<N> {
        StringMatchBuilder builder;

        UriNestedImpl(StringMatch item) {
            this.builder = new StringMatchBuilder(this, item);
        }

        UriNestedImpl() {
            this.builder = new StringMatchBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPMatchRequestFluentImpl.this.withUri(this.builder.build());
        }

        @Override
        public N endUri() {
            return this.and();
        }
    }

    class SchemeNestedImpl<N>
    extends StringMatchFluentImpl<HTTPMatchRequestFluent.SchemeNested<N>>
    implements HTTPMatchRequestFluent.SchemeNested<N>,
    Nested<N> {
        StringMatchBuilder builder;

        SchemeNestedImpl(StringMatch item) {
            this.builder = new StringMatchBuilder(this, item);
        }

        SchemeNestedImpl() {
            this.builder = new StringMatchBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPMatchRequestFluentImpl.this.withScheme(this.builder.build());
        }

        @Override
        public N endScheme() {
            return this.and();
        }
    }

    class MethodNestedImpl<N>
    extends StringMatchFluentImpl<HTTPMatchRequestFluent.MethodNested<N>>
    implements HTTPMatchRequestFluent.MethodNested<N>,
    Nested<N> {
        StringMatchBuilder builder;

        MethodNestedImpl(StringMatch item) {
            this.builder = new StringMatchBuilder(this, item);
        }

        MethodNestedImpl() {
            this.builder = new StringMatchBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPMatchRequestFluentImpl.this.withMethod(this.builder.build());
        }

        @Override
        public N endMethod() {
            return this.and();
        }
    }

    class AuthorityNestedImpl<N>
    extends StringMatchFluentImpl<HTTPMatchRequestFluent.AuthorityNested<N>>
    implements HTTPMatchRequestFluent.AuthorityNested<N>,
    Nested<N> {
        StringMatchBuilder builder;

        AuthorityNestedImpl(StringMatch item) {
            this.builder = new StringMatchBuilder(this, item);
        }

        AuthorityNestedImpl() {
            this.builder = new StringMatchBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPMatchRequestFluentImpl.this.withAuthority(this.builder.build());
        }

        @Override
        public N endAuthority() {
            return this.and();
        }
    }
}

