/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client;

import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.PreClientRequestContext;
import com.linecorp.armeria.client.RequestOptions;
import com.linecorp.armeria.client.ResponseTimeoutMode;
import com.linecorp.armeria.client.UnprocessedRequestException;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.common.AttributesGetters;
import com.linecorp.armeria.common.ContextAwareEventLoop;
import com.linecorp.armeria.common.ExchangeType;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.RequestTarget;
import com.linecorp.armeria.common.RequestTargetForm;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAccess;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.common.util.ReleasableHolder;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.common.util.SystemInfo;
import com.linecorp.armeria.common.util.TextFormatter;
import com.linecorp.armeria.common.util.TimeoutMode;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.internal.client.ClientRequestContextExtension;
import com.linecorp.armeria.internal.client.ClientThreadLocalState;
import com.linecorp.armeria.internal.client.HttpSession;
import com.linecorp.armeria.internal.client.UserAgentUtil;
import com.linecorp.armeria.internal.common.CancellationScheduler;
import com.linecorp.armeria.internal.common.HeaderOverridingHttpRequest;
import com.linecorp.armeria.internal.common.HttpHeadersUtil;
import com.linecorp.armeria.internal.common.NonWrappingRequestContext;
import com.linecorp.armeria.internal.common.RequestContextExtension;
import com.linecorp.armeria.internal.common.RequestContextUtil;
import com.linecorp.armeria.internal.common.SchemeAndAuthority;
import com.linecorp.armeria.internal.common.stream.FixedStreamMessage;
import com.linecorp.armeria.internal.common.util.ChannelUtil;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.util.AttributeKey;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultClientRequestContext
extends NonWrappingRequestContext
implements PreClientRequestContext,
ClientRequestContextExtension {
    private static final Logger logger = LoggerFactory.getLogger(DefaultClientRequestContext.class);
    private static final AtomicReferenceFieldUpdater<DefaultClientRequestContext, HttpHeaders> additionalRequestHeadersUpdater = AtomicReferenceFieldUpdater.newUpdater(DefaultClientRequestContext.class, HttpHeaders.class, "additionalRequestHeaders");
    private static final AtomicReferenceFieldUpdater<DefaultClientRequestContext, CompletableFuture> whenInitializedUpdater = AtomicReferenceFieldUpdater.newUpdater(DefaultClientRequestContext.class, CompletableFuture.class, "whenInitialized");
    private static final short STR_CHANNEL_AVAILABILITY = 1;
    private static final short STR_PARENT_LOG_AVAILABILITY = 2;
    private static boolean warnedNullRequestId;
    private boolean initialized;
    @Nullable
    private EventLoop eventLoop;
    private EndpointGroup endpointGroup;
    private SessionProtocol sessionProtocol;
    @Nullable
    private Endpoint endpoint;
    @Nullable
    private ContextAwareEventLoop contextAwareEventLoop;
    @Nullable
    private Channel channel;
    @Nullable
    private InetSocketAddress remoteAddress;
    @Nullable
    private InetSocketAddress localAddress;
    @Nullable
    private final ServiceRequestContext root;
    private final ClientOptions options;
    private final RequestLogBuilder log;
    private final CancellationScheduler responseCancellationScheduler;
    private long writeTimeoutMillis;
    private long maxResponseLength;
    private final HttpHeaders defaultRequestHeaders;
    private volatile HttpHeaders additionalRequestHeaders;
    private static final HttpHeaders defaultInternalRequestHeaders;
    private HttpHeaders internalRequestHeaders = defaultInternalRequestHeaders;
    @Nullable
    private String strVal;
    private short strValAvailabilities;
    @Nullable
    private volatile CompletableFuture<Boolean> whenInitialized;
    private final ResponseTimeoutMode responseTimeoutMode;

    private static SessionProtocol desiredSessionProtocol(SessionProtocol protocol, ClientOptions options) {
        if (!options.factory().options().preferHttp1()) {
            return protocol;
        }
        switch (protocol) {
            case HTTP: {
                return SessionProtocol.H1C;
            }
            case HTTPS: {
                return SessionProtocol.H1;
            }
        }
        return protocol;
    }

    public DefaultClientRequestContext(SessionProtocol sessionProtocol, HttpRequest httpRequest, @Nullable RpcRequest rpcRequest, RequestTarget requestTarget, EndpointGroup endpointGroup, RequestOptions requestOptions, ClientOptions clientOptions) {
        this(null, clientOptions.factory().meterRegistry(), sessionProtocol, DefaultClientRequestContext.nextRequestId(clientOptions), httpRequest.method(), requestTarget, endpointGroup, clientOptions, httpRequest, rpcRequest, requestOptions, DefaultClientRequestContext.serviceRequestContext(), null, System.nanoTime(), SystemInfo.currentTimeMicros());
    }

    public DefaultClientRequestContext(SessionProtocol sessionProtocol, @Nullable HttpRequest httpRequest, HttpMethod method, @Nullable RpcRequest rpcRequest, RequestTarget requestTarget, EndpointGroup endpointGroup, RequestOptions requestOptions, ClientOptions clientOptions, MeterRegistry meterRegistry) {
        this(null, meterRegistry, sessionProtocol, DefaultClientRequestContext.nextRequestId(clientOptions), method, requestTarget, endpointGroup, clientOptions, httpRequest, rpcRequest, requestOptions, DefaultClientRequestContext.serviceRequestContext(), null, System.nanoTime(), SystemInfo.currentTimeMicros());
    }

    public DefaultClientRequestContext(SessionProtocol sessionProtocol, @Nullable HttpRequest httpRequest, HttpMethod method, @Nullable RpcRequest rpcRequest, RequestTarget requestTarget, EndpointGroup endpointGroup, RequestOptions requestOptions, ClientOptions clientOptions) {
        this(null, clientOptions.factory().meterRegistry(), sessionProtocol, DefaultClientRequestContext.nextRequestId(clientOptions), method, requestTarget, endpointGroup, clientOptions, httpRequest, rpcRequest, requestOptions, DefaultClientRequestContext.serviceRequestContext(), null, System.nanoTime(), SystemInfo.currentTimeMicros());
    }

    public DefaultClientRequestContext(@Nullable EventLoop eventLoop, MeterRegistry meterRegistry, SessionProtocol sessionProtocol, RequestId id, HttpMethod method, RequestTarget reqTarget, EndpointGroup endpointGroup, ClientOptions options, @Nullable HttpRequest req, @Nullable RpcRequest rpcReq, RequestOptions requestOptions, CancellationScheduler responseCancellationScheduler, long requestStartTimeNanos, long requestStartTimeMicros) {
        this(eventLoop, meterRegistry, sessionProtocol, id, method, reqTarget, endpointGroup, options, req, rpcReq, requestOptions, DefaultClientRequestContext.serviceRequestContext(), Objects.requireNonNull(responseCancellationScheduler, "responseCancellationScheduler"), requestStartTimeNanos, requestStartTimeMicros);
    }

    public DefaultClientRequestContext(MeterRegistry meterRegistry, SessionProtocol sessionProtocol, RequestId id, HttpMethod method, RequestTarget reqTarget, EndpointGroup endpointGroup, ClientOptions options, HttpRequest req, @Nullable RpcRequest rpcReq, RequestOptions requestOptions, long requestStartTimeNanos, long requestStartTimeMicros) {
        this(null, meterRegistry, sessionProtocol, id, method, reqTarget, endpointGroup, options, req, rpcReq, requestOptions, DefaultClientRequestContext.serviceRequestContext(), null, requestStartTimeNanos, requestStartTimeMicros);
    }

    private DefaultClientRequestContext(@Nullable EventLoop eventLoop, MeterRegistry meterRegistry, SessionProtocol sessionProtocol, RequestId id, HttpMethod method, RequestTarget reqTarget, EndpointGroup endpointGroup, ClientOptions options, @Nullable HttpRequest req, @Nullable RpcRequest rpcReq, RequestOptions requestOptions, @Nullable ServiceRequestContext root, @Nullable CancellationScheduler responseCancellationScheduler, long requestStartTimeNanos, long requestStartTimeMicros) {
        super(meterRegistry, id, method, reqTarget, DefaultClientRequestContext.guessExchangeType(requestOptions, req), DefaultClientRequestContext.requestAutoAbortDelayMillis(options, requestOptions), req, rpcReq, DefaultClientRequestContext.getAttributes(root), options.contextHook());
        this.sessionProtocol = DefaultClientRequestContext.desiredSessionProtocol(sessionProtocol, options);
        this.eventLoop = eventLoop;
        this.options = Objects.requireNonNull(options, "options");
        this.root = root;
        this.endpointGroup = endpointGroup;
        this.log = RequestLog.builder(this);
        this.log.startRequest(requestStartTimeNanos, requestStartTimeMicros);
        if (responseCancellationScheduler == null) {
            long responseTimeoutMillis = requestOptions.responseTimeoutMillis();
            if (responseTimeoutMillis < 0L) {
                responseTimeoutMillis = this.options().responseTimeoutMillis();
            }
            this.responseCancellationScheduler = CancellationScheduler.ofClient(TimeUnit.MILLISECONDS.toNanos(responseTimeoutMillis));
        } else {
            this.responseCancellationScheduler = responseCancellationScheduler;
        }
        long writeTimeoutMillis = requestOptions.writeTimeoutMillis();
        if (writeTimeoutMillis < 0L) {
            writeTimeoutMillis = options.writeTimeoutMillis();
        }
        this.writeTimeoutMillis = writeTimeoutMillis;
        long maxResponseLength = requestOptions.maxResponseLength();
        if (maxResponseLength < 0L) {
            maxResponseLength = options.maxResponseLength();
        }
        this.maxResponseLength = maxResponseLength;
        for (Map.Entry<AttributeKey<?>, Object> attr : requestOptions.attrs().entrySet()) {
            this.setAttr(attr.getKey(), attr.getValue());
        }
        this.defaultRequestHeaders = (HttpHeaders)options.get(ClientOptions.HEADERS);
        this.additionalRequestHeaders = HttpHeaders.of();
        this.responseTimeoutMode = DefaultClientRequestContext.responseTimeoutMode(options, requestOptions);
    }

    private static ExchangeType guessExchangeType(RequestOptions requestOptions, @Nullable HttpRequest req) {
        ExchangeType exchangeType = requestOptions.exchangeType();
        if (exchangeType != null) {
            return exchangeType;
        }
        if (req instanceof FixedStreamMessage) {
            return ExchangeType.RESPONSE_STREAMING;
        }
        if (req instanceof HeaderOverridingHttpRequest && ((HeaderOverridingHttpRequest)req).delegate() instanceof FixedStreamMessage) {
            return ExchangeType.RESPONSE_STREAMING;
        }
        return ExchangeType.BIDI_STREAMING;
    }

    private static long requestAutoAbortDelayMillis(ClientOptions options, RequestOptions requestOptions) {
        Long requestAutoAbortDelayMillis = requestOptions.requestAutoAbortDelayMillis();
        if (requestAutoAbortDelayMillis != null) {
            return requestAutoAbortDelayMillis;
        }
        return options.requestAutoAbortDelayMillis();
    }

    @Nullable
    private static AttributesGetters getAttributes(@Nullable ServiceRequestContext ctx) {
        if (ctx == null) {
            return null;
        }
        RequestContextExtension ctxExtension = ctx.as(RequestContextExtension.class);
        if (ctxExtension == null) {
            return null;
        }
        return ctxExtension.attributes();
    }

    @Nullable
    private static ServiceRequestContext serviceRequestContext() {
        Object current = RequestContext.currentOrNull();
        return current != null ? current.root() : null;
    }

    @Override
    public CompletableFuture<Boolean> init() {
        assert (this.endpoint == null) : this.endpoint;
        assert (!this.initialized);
        this.initialized = true;
        Throwable cancellationCause = this.cancellationCause();
        if (cancellationCause != null) {
            this.acquireEventLoop(this.endpointGroup);
            this.failEarly(cancellationCause);
            return DefaultClientRequestContext.initFuture(false, null);
        }
        try {
            this.endpointGroup = this.mapEndpoint(this.endpointGroup);
            if (this.endpointGroup instanceof Endpoint) {
                return this.initEndpoint((Endpoint)this.endpointGroup);
            }
            return this.initEndpointGroup(this.endpointGroup);
        }
        catch (Throwable t) {
            this.acquireEventLoop(this.endpointGroup);
            this.failEarly(t);
            return DefaultClientRequestContext.initFuture(false, null);
        }
    }

    private EndpointGroup mapEndpoint(EndpointGroup endpointGroup) {
        if (endpointGroup instanceof Endpoint) {
            return Objects.requireNonNull(this.options().endpointRemapper().apply((Endpoint)endpointGroup), "endpointRemapper returned null.");
        }
        return endpointGroup;
    }

    private CompletableFuture<Boolean> initEndpoint(Endpoint endpoint) {
        this.updateEndpoint(endpoint);
        this.acquireEventLoop(endpoint);
        return DefaultClientRequestContext.initFuture(true, null);
    }

    private CompletableFuture<Boolean> initEndpointGroup(EndpointGroup endpointGroup) {
        this.endpointGroup = endpointGroup;
        Endpoint endpoint = endpointGroup.selectNow(this);
        if (endpoint != null) {
            this.updateEndpoint(endpoint);
            this.acquireEventLoop(endpointGroup);
            return DefaultClientRequestContext.initFuture(true, null);
        }
        EventLoop temporaryEventLoop = this.options().factory().eventLoopSupplier().get();
        return ((CompletableFuture)endpointGroup.select(this, temporaryEventLoop).handle((e, cause) -> {
            boolean success;
            this.updateEndpoint((Endpoint)e);
            this.acquireEventLoop(endpointGroup);
            if (cause != null) {
                this.failEarly((Throwable)cause);
                success = false;
            } else {
                success = true;
            }
            ContextAwareEventLoop acquiredEventLoop = this.eventLoop();
            if (acquiredEventLoop == temporaryEventLoop) {
                return DefaultClientRequestContext.initFuture(success, null);
            }
            return DefaultClientRequestContext.initFuture(success, acquiredEventLoop);
        })).thenCompose(Function.identity());
    }

    private static CompletableFuture<Boolean> initFuture(boolean success, @Nullable EventLoop acquiredEventLoop) {
        if (acquiredEventLoop == null) {
            return UnmodifiableFuture.completedFuture(success);
        }
        return CompletableFuture.supplyAsync(() -> success, acquiredEventLoop);
    }

    @Override
    public CompletableFuture<Boolean> whenInitialized() {
        CompletableFuture<Boolean> whenInitialized = this.whenInitialized;
        if (whenInitialized != null) {
            return whenInitialized;
        }
        whenInitialized = new CompletableFuture();
        if (whenInitializedUpdater.compareAndSet(this, null, whenInitialized)) {
            return whenInitialized;
        }
        CompletableFuture<Boolean> oldWhenInitialized = this.whenInitialized;
        assert (oldWhenInitialized != null);
        return oldWhenInitialized;
    }

    @Override
    public void finishInitialization(boolean success) {
        CompletableFuture<Boolean> whenInitialized = this.whenInitialized;
        if (whenInitialized != null) {
            whenInitialized.complete(success);
        } else if (!whenInitializedUpdater.compareAndSet(this, null, UnmodifiableFuture.completedFuture(success))) {
            CompletableFuture<Boolean> oldWhenInitialized = this.whenInitialized;
            assert (oldWhenInitialized != null);
            oldWhenInitialized.complete(success);
        }
    }

    private void updateEndpoint(@Nullable Endpoint endpoint) {
        this.endpoint = endpoint;
        this.autoFillSchemeAuthorityAndOrigin();
    }

    private void acquireEventLoop(EndpointGroup endpointGroup) {
        if (this.eventLoop == null) {
            ReleasableHolder<EventLoop> releasableEventLoop = this.options().factory().acquireEventLoop(this.sessionProtocol(), endpointGroup, this.endpoint);
            this.eventLoop = releasableEventLoop.get();
            this.log.whenComplete().thenAccept(unused -> releasableEventLoop.release());
            this.initializeResponseCancellationScheduler();
        }
    }

    @Override
    public void runContextCustomizer() {
        Consumer<ClientRequestContext> optionsCustomizer = this.options.contextCustomizer();
        Consumer<ClientRequestContext> threadLocalCustomizer = this.copyThreadLocalCustomizer();
        Consumer<ClientRequestContext> customizer = optionsCustomizer == ClientOptions.CONTEXT_CUSTOMIZER.defaultValue() ? threadLocalCustomizer : (threadLocalCustomizer == null ? optionsCustomizer : optionsCustomizer.andThen(threadLocalCustomizer));
        if (customizer != null) {
            try {
                customizer.accept(this);
            }
            catch (Throwable t) {
                this.cancel(UnprocessedRequestException.of(t));
            }
        }
    }

    private void failEarly(Throwable cause) {
        UnprocessedRequestException wrapped = UnprocessedRequestException.of(cause);
        HttpRequest req = this.request();
        if (req != null) {
            this.autoFillSchemeAuthorityAndOrigin();
            req.abort(wrapped);
        }
        RequestLogBuilder logBuilder = this.logBuilder();
        logBuilder.endRequest(wrapped);
        logBuilder.endResponse(wrapped);
    }

    private void autoFillSchemeAuthorityAndOrigin() {
        String host;
        String authority = this.authority();
        if (authority != null && this.endpoint != null && this.endpoint.isIpAddrOnly() && !NetUtil.isValidIpV4Address(host = SchemeAndAuthority.of(null, authority).host()) && !NetUtil.isValidIpV6Address(host)) {
            this.endpoint = this.endpoint.withHost(host);
        }
        HttpHeadersBuilder headersBuilder = this.internalRequestHeaders.toBuilder();
        headersBuilder.set((CharSequence)HttpHeaderNames.SCHEME, HttpHeadersUtil.getScheme(this.sessionProtocol()));
        if (this.endpoint != null) {
            String endpointAuthority = this.endpoint.authority();
            headersBuilder.set((CharSequence)HttpHeaderNames.AUTHORITY, endpointAuthority);
            String origin = this.origin();
            if (origin != null) {
                headersBuilder.set((CharSequence)HttpHeaderNames.ORIGIN, origin);
            } else if (this.options().autoFillOriginHeader()) {
                String uriText = this.sessionProtocol().isTls() ? SessionProtocol.HTTPS.uriText() : SessionProtocol.HTTP.uriText();
                headersBuilder.set((CharSequence)HttpHeaderNames.ORIGIN, uriText + "://" + endpointAuthority);
            }
        }
        this.internalRequestHeaders = headersBuilder.build();
    }

    private DefaultClientRequestContext(DefaultClientRequestContext ctx, RequestId id, @Nullable HttpRequest req, @Nullable RpcRequest rpcReq, @Nullable Endpoint endpoint, EndpointGroup endpointGroup, SessionProtocol sessionProtocol, HttpMethod method, RequestTarget reqTarget) {
        super(ctx.meterRegistry(), id, method, reqTarget, ctx.exchangeType(), ctx.requestAutoAbortDelayMillis(), req, rpcReq, DefaultClientRequestContext.getAttributes(ctx.root()), ctx.hook());
        if (ctx.request() != null) {
            Objects.requireNonNull(req, "req");
        }
        this.sessionProtocol = Objects.requireNonNull(sessionProtocol, "sessionProtocol");
        this.options = ctx.options();
        this.root = ctx.root();
        this.log = RequestLog.builder(this);
        this.log.startRequest();
        ctx.responseCancellationScheduler.cancelScheduled();
        this.responseCancellationScheduler = CancellationScheduler.ofClient(ctx.remainingTimeoutNanos());
        this.writeTimeoutMillis = ctx.writeTimeoutMillis();
        this.maxResponseLength = ctx.maxResponseLength();
        this.defaultRequestHeaders = ctx.defaultRequestHeaders();
        this.additionalRequestHeaders = ctx.additionalRequestHeaders();
        this.responseTimeoutMode = ctx.responseTimeoutMode();
        Iterator<Map.Entry<AttributeKey<?>, Object>> i = ctx.ownAttrs();
        while (i.hasNext()) {
            this.addAttr(i.next());
        }
        this.endpointGroup = endpointGroup;
        this.updateEndpoint(endpoint);
        if (endpoint == null || ctx.endpoint() == endpoint && ctx.log.children().isEmpty()) {
            this.eventLoop = ctx.eventLoop().withoutContext();
            this.initializeResponseCancellationScheduler();
        } else {
            this.acquireEventLoop(endpoint);
        }
    }

    private void initializeResponseCancellationScheduler() {
        CancellationScheduler.CancellationTask cancellationTask = cause -> {
            try (SafeCloseable ignored = RequestContextUtil.pop();){
                HttpRequest request = this.request();
                if (request != null) {
                    request.abort(cause);
                }
                this.log.endRequest(cause);
                this.log.endResponse(cause);
            }
        };
        if (this.responseTimeoutMode() == ResponseTimeoutMode.FROM_START) {
            this.responseCancellationScheduler.initAndStart(this.eventLoop().withoutContext(), cancellationTask);
        } else {
            this.responseCancellationScheduler.init(this.eventLoop().withoutContext());
            this.responseCancellationScheduler.updateTask(cancellationTask);
        }
    }

    @Nullable
    private Consumer<ClientRequestContext> copyThreadLocalCustomizer() {
        ClientThreadLocalState state = ClientThreadLocalState.get();
        if (state == null) {
            return null;
        }
        state.addCapturedContext(this);
        List<Consumer<? super ClientRequestContext>> customizers = state.copyCustomizers();
        if (customizers == null) {
            return null;
        }
        return ctx -> {
            for (Consumer c : customizers) {
                c.accept(this);
            }
        };
    }

    private <T> void addAttr(Map.Entry<AttributeKey<?>, Object> attribute) {
        this.setAttr(attribute.getKey(), attribute.getValue());
    }

    @Override
    @Nullable
    public ServiceRequestContext root() {
        return this.root;
    }

    @Override
    public SessionProtocol sessionProtocol() {
        return this.sessionProtocol;
    }

    @Override
    public void setSessionProtocol(SessionProtocol sessionProtocol) {
        Preconditions.checkState(!this.initialized, "Cannot update sessionProtocol after initialization");
        this.sessionProtocol = DefaultClientRequestContext.desiredSessionProtocol(Objects.requireNonNull(sessionProtocol, "sessionProtocol"), this.options);
    }

    @Override
    public ClientRequestContext newDerivedContext(RequestId id, @Nullable HttpRequest req, @Nullable RpcRequest rpcReq, @Nullable Endpoint endpoint) {
        if (req != null) {
            String newPath;
            RequestHeaders newHeaders = req.headers();
            String oldPath = this.requestTarget().pathAndQuery();
            if (!oldPath.equals(newPath = newHeaders.path())) {
                RequestTarget reqTarget = RequestTarget.forClient(newPath);
                Preconditions.checkArgument(reqTarget != null, "invalid path: %s", (Object)newPath);
                if (reqTarget.form() != RequestTargetForm.ABSOLUTE) {
                    return new DefaultClientRequestContext(this, id, req, rpcReq, endpoint, this.endpointGroup, this.sessionProtocol(), newHeaders.method(), reqTarget);
                }
                String scheme = reqTarget.scheme();
                String authority = reqTarget.authority();
                assert (scheme != null);
                assert (authority != null);
                SessionProtocol protocol = Scheme.parse(scheme).sessionProtocol();
                Endpoint newEndpoint = Endpoint.parse(authority);
                HttpRequest newReq = req.withHeaders(req.headers().toBuilder().path(reqTarget.pathAndQuery()));
                return new DefaultClientRequestContext(this, id, newReq, rpcReq, newEndpoint, (EndpointGroup)newEndpoint, protocol, newHeaders.method(), reqTarget);
            }
        }
        return new DefaultClientRequestContext(this, id, req, rpcReq, endpoint, this.endpointGroup, this.sessionProtocol(), this.method(), this.requestTarget());
    }

    @Override
    @Nullable
    protected RequestTarget validateHeaders(RequestHeaders headers) {
        return RequestTarget.forClient(headers.path());
    }

    @Override
    @Nullable
    protected Channel channel() {
        Channel newChannel;
        Channel channel = this.channel;
        if (channel != null) {
            return channel;
        }
        if (!this.log.isAvailable(RequestLogProperty.SESSION)) {
            return null;
        }
        this.channel = newChannel = this.log.partial().channel();
        return newChannel;
    }

    @Override
    @Nullable
    public InetSocketAddress remoteAddress() {
        InetSocketAddress newRemoteAddress;
        InetSocketAddress remoteAddress = this.remoteAddress;
        if (remoteAddress != null) {
            return remoteAddress;
        }
        this.remoteAddress = newRemoteAddress = ChannelUtil.remoteAddress(this.channel());
        return newRemoteAddress;
    }

    @Override
    @Nullable
    public InetSocketAddress localAddress() {
        InetSocketAddress newLocalAddress;
        InetSocketAddress localAddress = this.localAddress;
        if (localAddress != null) {
            return localAddress;
        }
        this.localAddress = newLocalAddress = ChannelUtil.localAddress(this.channel());
        return newLocalAddress;
    }

    @Override
    public ContextAwareEventLoop eventLoop() {
        Preconditions.checkState(this.eventLoop != null, "Should call init(endpoint) before invoking this method.");
        if (this.contextAwareEventLoop != null) {
            return this.contextAwareEventLoop;
        }
        this.contextAwareEventLoop = ContextAwareEventLoop.of((RequestContext)this, this.eventLoop);
        return this.contextAwareEventLoop;
    }

    @Override
    public void setEventLoop(EventLoop eventLoop) {
        Preconditions.checkState(!this.initialized, "Cannot update eventLoop after initialization");
        Preconditions.checkState(this.eventLoop == null, "eventLoop can be updated only once");
        this.eventLoop = Objects.requireNonNull(eventLoop, "eventLoop");
        this.initializeResponseCancellationScheduler();
    }

    @Override
    public ByteBufAllocator alloc() {
        Channel channel = this.channel();
        return channel != null ? channel.alloc() : PooledByteBufAllocator.DEFAULT;
    }

    @Override
    @Nullable
    public SSLSession sslSession() {
        RequestLog requestLog = this.log.getIfAvailable(RequestLogProperty.SESSION);
        return requestLog != null ? requestLog.sslSession() : null;
    }

    @Override
    public ClientOptions options() {
        return this.options;
    }

    @Override
    public EndpointGroup endpointGroup() {
        return this.endpointGroup;
    }

    @Override
    public void setEndpointGroup(EndpointGroup endpointGroup) {
        Preconditions.checkState(!this.initialized, "Cannot update endpointGroup after initialization");
        this.endpointGroup = Objects.requireNonNull(endpointGroup, "endpointGroup");
    }

    @Override
    @Nullable
    public Endpoint endpoint() {
        return this.endpoint;
    }

    @Override
    @Nullable
    public String fragment() {
        return this.requestTarget().fragment();
    }

    @Override
    @Nullable
    public String authority() {
        HttpHeaders additionalRequestHeaders = this.additionalRequestHeaders;
        String authority = additionalRequestHeaders.get(HttpHeaderNames.AUTHORITY);
        if (authority == null) {
            authority = additionalRequestHeaders.get(HttpHeaderNames.HOST);
        }
        HttpRequest request = this.request();
        if (authority == null && request != null) {
            authority = request.authority();
        }
        if (authority == null) {
            authority = this.defaultRequestHeaders.get(HttpHeaderNames.AUTHORITY);
        }
        if (authority == null) {
            authority = this.defaultRequestHeaders.get(HttpHeaderNames.HOST);
        }
        if (authority == null) {
            authority = this.internalRequestHeaders.get(HttpHeaderNames.AUTHORITY);
        }
        if (authority == null) {
            authority = this.internalRequestHeaders.get(HttpHeaderNames.HOST);
        }
        return authority;
    }

    @Nullable
    private String origin() {
        HttpHeaders additionalRequestHeaders = this.additionalRequestHeaders;
        String origin = additionalRequestHeaders.get(HttpHeaderNames.ORIGIN);
        HttpRequest request = this.request();
        if (origin == null && request != null) {
            origin = request.headers().get(HttpHeaderNames.ORIGIN);
        }
        if (origin == null) {
            origin = this.defaultRequestHeaders.get(HttpHeaderNames.ORIGIN);
        }
        if (origin == null) {
            origin = this.internalRequestHeaders.get(HttpHeaderNames.ORIGIN);
        }
        return origin;
    }

    @Override
    @Nullable
    public String host() {
        String authority = this.authority();
        if (authority == null) {
            return null;
        }
        return SchemeAndAuthority.of(null, authority).host();
    }

    @Override
    public URI uri() {
        String scheme = HttpHeadersUtil.getScheme(this.sessionProtocol());
        String authority = this.authority();
        String path = this.path();
        String query = this.query();
        String fragment = this.fragment();
        TemporaryThreadLocals tmp = TemporaryThreadLocals.acquire();
        try {
            StringBuilder buf = tmp.stringBuilder();
            buf.append(scheme);
            if (authority != null) {
                buf.append("://").append(authority);
            } else {
                buf.append(':');
            }
            buf.append(path);
            if (query != null) {
                buf.append('?').append(query);
            }
            if (fragment != null) {
                buf.append('#').append(fragment);
            }
            URI uRI = new URI(buf.toString());
            if (tmp != null) {
                tmp.close();
            }
            return uRI;
        }
        catch (Throwable throwable) {
            try {
                if (tmp != null) {
                    try {
                        tmp.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("not a valid URI", e);
            }
        }
    }

    @Override
    public long writeTimeoutMillis() {
        return this.writeTimeoutMillis;
    }

    @Override
    public void setWriteTimeoutMillis(long writeTimeoutMillis) {
        Preconditions.checkArgument(writeTimeoutMillis >= 0L, "writeTimeoutMillis: %s (expected: >= 0)", writeTimeoutMillis);
        this.writeTimeoutMillis = writeTimeoutMillis;
    }

    @Override
    public void setWriteTimeout(Duration writeTimeout) {
        this.setWriteTimeoutMillis(Objects.requireNonNull(writeTimeout, "writeTimeout").toMillis());
    }

    @Override
    public long responseTimeoutMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.responseCancellationScheduler.timeoutNanos());
    }

    @Override
    public void clearResponseTimeout() {
        this.responseCancellationScheduler.clearTimeout();
    }

    @Override
    public void setResponseTimeoutMillis(TimeoutMode mode, long responseTimeoutMillis) {
        this.responseCancellationScheduler.setTimeoutNanos(Objects.requireNonNull(mode, "mode"), TimeUnit.MILLISECONDS.toNanos(responseTimeoutMillis));
    }

    @Override
    public void setResponseTimeout(TimeoutMode mode, Duration responseTimeout) {
        this.responseCancellationScheduler.setTimeoutNanos(Objects.requireNonNull(mode, "mode"), Objects.requireNonNull(responseTimeout, "responseTimeout").toNanos());
    }

    @Override
    public long maxResponseLength() {
        return this.maxResponseLength;
    }

    @Override
    public void setMaxResponseLength(long maxResponseLength) {
        Preconditions.checkArgument(maxResponseLength >= 0L, "maxResponseLength: %s (expected: >= 0)", maxResponseLength);
        this.maxResponseLength = maxResponseLength;
    }

    @Override
    public HttpHeaders defaultRequestHeaders() {
        return this.defaultRequestHeaders;
    }

    @Override
    public HttpHeaders additionalRequestHeaders() {
        return this.additionalRequestHeaders;
    }

    @Override
    public HttpHeaders internalRequestHeaders() {
        return this.internalRequestHeaders;
    }

    @Override
    public long remainingTimeoutNanos() {
        return this.responseCancellationScheduler().remainingTimeoutNanos();
    }

    @Override
    public void setAdditionalRequestHeader(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        this.mutateAdditionalRequestHeaders(builder -> builder.setObject(name, value));
    }

    @Override
    public void addAdditionalRequestHeader(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        this.mutateAdditionalRequestHeaders(builder -> builder.addObject(name, value));
    }

    @Override
    public void mutateAdditionalRequestHeaders(Consumer<HttpHeadersBuilder> mutator) {
        HttpHeadersBuilder builder;
        HttpHeaders newValue;
        HttpHeaders oldValue;
        Objects.requireNonNull(mutator, "mutator");
        do {
            oldValue = this.additionalRequestHeaders;
            builder = oldValue.toBuilder();
            mutator.accept(builder);
        } while (!additionalRequestHeadersUpdater.compareAndSet(this, oldValue, newValue = builder.build()));
    }

    @Override
    public RequestLogAccess log() {
        return this.log;
    }

    @Override
    public RequestLogBuilder logBuilder() {
        return this.log;
    }

    @Override
    public CancellationScheduler responseCancellationScheduler() {
        return this.responseCancellationScheduler;
    }

    @Override
    public void cancel(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        this.responseCancellationScheduler.finishNow(cause);
    }

    @Override
    @Nullable
    public Throwable cancellationCause() {
        return this.responseCancellationScheduler.cause();
    }

    @Override
    public CompletableFuture<Throwable> whenResponseCancelling() {
        return this.responseCancellationScheduler.whenCancelling();
    }

    @Override
    public CompletableFuture<Throwable> whenResponseCancelled() {
        return this.responseCancellationScheduler.whenCancelled();
    }

    @Override
    @Deprecated
    public CompletableFuture<Void> whenResponseTimingOut() {
        return this.whenResponseCancelling().handle((v, e) -> null);
    }

    @Override
    @Deprecated
    public CompletableFuture<Void> whenResponseTimedOut() {
        return this.whenResponseCancelled().handle((v, e) -> null);
    }

    public String toString() {
        Channel ch = this.channel();
        RequestLogAccess parent = this.log().parent();
        short newAvailability = (short)((ch != null ? 1 : 0) | (parent != null ? 2 : 0));
        if (this.strVal != null && this.strValAvailabilities == newAvailability) {
            return this.strVal;
        }
        this.strValAvailabilities = newAvailability;
        this.strVal = this.toStringSlow(parent);
        return this.strVal;
    }

    private String toStringSlow(@Nullable RequestLogAccess parent) {
        Channel ch = this.channel();
        String creqId = this.id().shortText();
        String preqId = parent != null ? parent.context().id().shortText() : null;
        String sreqId = this.root() != null ? this.root().id().shortText() : null;
        String chanId = ch != null ? ch.id().asShortText() : null;
        String proto = this.sessionProtocol().uriText();
        String authority = this.endpoint != null ? this.endpoint.authority() : "UNKNOWN";
        String path = this.path();
        String method = this.method().name();
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            StringBuilder buf = tempThreadLocals.stringBuilder();
            buf.append("[creqId=").append(creqId);
            if (parent != null) {
                buf.append(", preqId=").append(preqId);
            }
            if (sreqId != null) {
                buf.append(", sreqId=").append(sreqId);
            }
            if (ch != null) {
                InetSocketAddress laddr = this.localAddress();
                InetSocketAddress raddr = this.remoteAddress();
                buf.append(", chanId=").append(chanId);
                buf.append(", laddr=");
                TextFormatter.appendSocketAddress(buf, laddr);
                if (!Objects.equals(laddr, raddr)) {
                    buf.append(", raddr=");
                    TextFormatter.appendSocketAddress(buf, raddr);
                }
            }
            buf.append("][").append(proto).append("://").append(authority).append(path).append('#').append(method).append(']');
            String string = buf.toString();
            return string;
        }
    }

    @Override
    public CompletableFuture<Void> initiateConnectionShutdown() {
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.setAdditionalRequestHeader(HttpHeaderNames.CONNECTION, HttpHeaderValues.CLOSE);
        this.log().whenRequestComplete().thenAccept(log -> {
            Channel ch = log.channel();
            if (ch == null) {
                Throwable ex = log.requestCause();
                if (ex == null) {
                    completableFuture.completeExceptionally(new IllegalStateException("A request has failed before a connection is established."));
                } else {
                    completableFuture.completeExceptionally(ex);
                }
            } else {
                ch.closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
                    if (f.cause() == null) {
                        completableFuture.complete(null);
                    } else {
                        completableFuture.completeExceptionally(f.cause());
                    }
                }));
                HttpSession.get(ch).markUnacquirable();
            }
        });
        return completableFuture;
    }

    @Override
    public ResponseTimeoutMode responseTimeoutMode() {
        return this.responseTimeoutMode;
    }

    private static ResponseTimeoutMode responseTimeoutMode(ClientOptions options, RequestOptions requestOptions) {
        ResponseTimeoutMode requestOptionTimeoutMode = requestOptions.responseTimeoutMode();
        if (requestOptionTimeoutMode != null) {
            return requestOptionTimeoutMode;
        }
        return options.responseTimeoutMode();
    }

    private static RequestId nextRequestId(ClientOptions options) {
        RequestId id = options.requestIdGenerator().get();
        if (id == null) {
            if (!warnedNullRequestId) {
                warnedNullRequestId = true;
                logger.warn("requestIdGenerator.get() returned null; using RequestId.random()");
            }
            return RequestId.random();
        }
        return id;
    }

    static {
        defaultInternalRequestHeaders = HttpHeaders.of((CharSequence)HttpHeaderNames.USER_AGENT, UserAgentUtil.USER_AGENT.toString());
    }
}

