/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.metric.MoreMeters;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.ArmeriaHttp2HeadersDecoder;
import com.linecorp.armeria.internal.common.KeepAliveHandler;
import com.linecorp.armeria.internal.common.KeepAliveHandlerUtil;
import com.linecorp.armeria.internal.common.NoopKeepAliveHandler;
import com.linecorp.armeria.internal.common.ReadSuppressingHandler;
import com.linecorp.armeria.internal.common.TrafficLoggingHandler;
import com.linecorp.armeria.internal.common.util.CertificateUtil;
import com.linecorp.armeria.internal.common.util.ChannelUtil;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.GracefulShutdownSupport;
import com.linecorp.armeria.server.Http1RequestDecoder;
import com.linecorp.armeria.server.Http1ServerKeepAliveHandler;
import com.linecorp.armeria.server.Http2ServerConnectionHandlerBuilder;
import com.linecorp.armeria.server.Http2ServerUpgradeCodec;
import com.linecorp.armeria.server.HttpServer;
import com.linecorp.armeria.server.HttpServerCodec;
import com.linecorp.armeria.server.HttpServerHandler;
import com.linecorp.armeria.server.HttpServerUpgradeHandler;
import com.linecorp.armeria.server.ProxiedAddresses;
import com.linecorp.armeria.server.ServerHttp1ObjectEncoder;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.armeria.server.TlsProviderMapping;
import com.linecorp.armeria.server.UpdatableServerConfig;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import io.netty.handler.codec.haproxy.HAProxyProxiedProtocol;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2InboundFrameLogger;
import io.netty.handler.codec.http2.Http2OutboundFrameLogger;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AsciiString;
import io.netty.util.Mapping;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpServerPipelineConfigurator
extends ChannelInitializer<Channel> {
    private static final Logger logger = LoggerFactory.getLogger(HttpServerPipelineConfigurator.class);
    private static final int SSL_RECORD_HEADER_LENGTH = 5;
    static final AsciiString SCHEME_HTTP = AsciiString.cached("http");
    static final AsciiString SCHEME_HTTPS = AsciiString.cached("https");
    private static final byte[] PROXY_V1_MAGIC_BYTES = new byte[]{80, 82, 79, 88, 89};
    private static final byte[] PROXY_V2_MAGIC_BYTES = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10};
    private static final Http2FrameLogger frameLogger = new Http2FrameLogger(LogLevel.TRACE, "com.linecorp.armeria.logging.traffic.server.http2");
    private final ServerPort port;
    private final UpdatableServerConfig config;
    private final GracefulShutdownSupport gracefulShutdownSupport;
    private final boolean hasWebSocketService;

    HttpServerPipelineConfigurator(UpdatableServerConfig config, ServerPort port, GracefulShutdownSupport gracefulShutdownSupport, boolean hasWebSocketService) {
        this.config = config;
        this.port = Objects.requireNonNull(port, "port");
        this.gracefulShutdownSupport = Objects.requireNonNull(gracefulShutdownSupport, "gracefulShutdownSupport");
        this.hasWebSocketService = hasWebSocketService;
    }

    @Override
    protected void initChannel(Channel ch) throws Exception {
        ch.remoteAddress();
        ChannelUtil.disableWriterBufferWatermark(ch);
        ChannelPipeline p = ch.pipeline();
        p.addLast(new FlushConsolidationHandler());
        p.addLast(ReadSuppressingHandler.INSTANCE);
        this.configurePipeline(p, this.port.protocols(), null);
        this.config.childChannelPipelineCustomizer().accept(p);
    }

    private void configurePipeline(ChannelPipeline p, Set<SessionProtocol> protocols, @Nullable ProxiedAddresses proxiedAddresses) {
        ScheduledFuture<?> protocolDetectionTimeoutFuture;
        if (protocols.size() == 1) {
            switch (protocols.iterator().next()) {
                case HTTP: {
                    this.configureHttp(p, proxiedAddresses);
                    break;
                }
                case HTTPS: {
                    this.configureHttps(p, proxiedAddresses);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            return;
        }
        long requestTimeoutMillis = this.config.defaultVirtualHost().requestTimeoutMillis();
        if (requestTimeoutMillis > 0L) {
            Channel ch = p.channel();
            protocolDetectionTimeoutFuture = ch.eventLoop().schedule(ch::close, requestTimeoutMillis, TimeUnit.MILLISECONDS);
        } else {
            protocolDetectionTimeoutFuture = null;
        }
        p.addLast(new ProtocolDetectionHandler(protocols, proxiedAddresses, protocolDetectionTimeoutFuture));
    }

    private void configureHttp(ChannelPipeline p, @Nullable ProxiedAddresses proxiedAddresses) {
        KeepAliveHandler keepAliveHandler;
        int maxNumRequestsPerConnection;
        long maxConnectionAgeMillis;
        long idleTimeoutMillis = this.config.idleTimeoutMillis();
        boolean needsKeepAliveHandler = KeepAliveHandlerUtil.needsKeepAliveHandler(idleTimeoutMillis, 0L, maxConnectionAgeMillis = this.config.maxConnectionAgeMillis(), maxNumRequestsPerConnection = this.config.maxNumRequestsPerConnection());
        if (needsKeepAliveHandler) {
            Timer keepAliveTimer = this.newKeepAliveTimer(SessionProtocol.H1C);
            keepAliveHandler = new Http1ServerKeepAliveHandler(p.channel(), keepAliveTimer, idleTimeoutMillis, maxConnectionAgeMillis, maxNumRequestsPerConnection);
        } else {
            keepAliveHandler = new NoopKeepAliveHandler();
        }
        ServerHttp1ObjectEncoder responseEncoder = new ServerHttp1ObjectEncoder(p.channel(), SessionProtocol.H1C, keepAliveHandler, this.config.http1HeaderNaming());
        p.addLast(TrafficLoggingHandler.SERVER);
        HttpServerHandler httpServerHandler = new HttpServerHandler(this.config, p.channel(), this.gracefulShutdownSupport, responseEncoder, SessionProtocol.H1C, proxiedAddresses);
        p.addLast(new Http2PrefaceOrHttpHandler(responseEncoder, httpServerHandler));
        p.addLast(httpServerHandler);
    }

    private Timer newKeepAliveTimer(SessionProtocol protocol) {
        return MoreMeters.newTimer(this.config.meterRegistry(), "armeria.server.connections.lifespan", ImmutableList.of(Tag.of("protocol", protocol.uriText())));
    }

    private void configureHttps(ChannelPipeline p, @Nullable ProxiedAddresses proxiedAddresses) {
        p.addLast(this.newSniHandler(p));
        p.addLast(TrafficLoggingHandler.SERVER);
        p.addLast(new Http2OrHttpHandler(proxiedAddresses));
    }

    private SniHandler newSniHandler(ChannelPipeline p) {
        Mapping<String, SslContext> sslContexts = Objects.requireNonNull(this.config.sslContextMapping(), "config.sslContextMapping() returned null");
        SniHandler sniHandler = new SniHandler(sslContexts, Flags.defaultMaxClientHelloLength(), this.config.idleTimeoutMillis());
        if (sslContexts instanceof TlsProviderMapping) {
            p.channel().closeFuture().addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                SslContext sslContext = sniHandler.sslContext();
                if (sslContext != null) {
                    ((TlsProviderMapping)sslContexts).release(sslContext);
                }
            }));
        }
        return sniHandler;
    }

    private Http2ConnectionHandler newHttp2ConnectionHandler(ChannelPipeline pipeline, AsciiString scheme) {
        Timer keepAliveTimer = this.newKeepAliveTimer(scheme == SCHEME_HTTP ? SessionProtocol.H2C : SessionProtocol.H2);
        DefaultHttp2Connection connection = new DefaultHttp2Connection(true);
        Http2ConnectionEncoder encoder = HttpServerPipelineConfigurator.encoder(connection);
        Http2ConnectionDecoder decoder = this.decoder(connection, encoder);
        return ((Http2ServerConnectionHandlerBuilder)((Http2ServerConnectionHandlerBuilder)new Http2ServerConnectionHandlerBuilder(pipeline.channel(), this.config, keepAliveTimer, this.gracefulShutdownSupport, scheme).codec(decoder, encoder)).initialSettings(this.http2Settings())).build();
    }

    private static Http2ConnectionEncoder encoder(Http2Connection connection) {
        Http2FrameWriter writer = new DefaultHttp2FrameWriter();
        writer = new Http2OutboundFrameLogger(writer, frameLogger);
        return new DefaultHttp2ConnectionEncoder(connection, writer);
    }

    private Http2ConnectionDecoder decoder(Http2Connection connection, Http2ConnectionEncoder encoder) {
        ArmeriaHttp2HeadersDecoder headersDecoder = new ArmeriaHttp2HeadersDecoder(true, this.config.http2MaxHeaderListSize());
        Http2FrameReader reader = new DefaultHttp2FrameReader(headersDecoder);
        reader = new Http2InboundFrameLogger(reader, frameLogger);
        return new DefaultHttp2ConnectionDecoder(connection, encoder, reader);
    }

    private Http2Settings http2Settings() {
        int maxFrameSize;
        Http2Settings settings = new Http2Settings();
        int initialWindowSize = this.config.http2InitialStreamWindowSize();
        if (initialWindowSize != 65535) {
            settings.initialWindowSize(initialWindowSize);
        }
        if ((maxFrameSize = this.config.http2MaxFrameSize()) != 16384) {
            settings.maxFrameSize(maxFrameSize);
        }
        settings.maxConcurrentStreams(Math.min(this.config.http2MaxStreamsPerConnection(), Integer.MAX_VALUE));
        settings.maxHeaderListSize(this.config.http2MaxHeaderListSize());
        if (this.hasWebSocketService) {
            settings.put('\b', 1L);
        }
        return settings;
    }

    private final class ProtocolDetectionHandler
    extends ByteToMessageDecoder {
        private final EnumSet<SessionProtocol> candidates;
        @Nullable
        private final EnumSet<SessionProtocol> proxiedCandidates;
        @Nullable
        private final ProxiedAddresses proxiedAddresses;
        @Nullable
        private final ScheduledFuture<?> timeoutFuture;

        ProtocolDetectionHandler(@Nullable Set<SessionProtocol> protocols, @Nullable ProxiedAddresses proxiedAddresses, ScheduledFuture<?> timeoutFuture) {
            this.candidates = EnumSet.copyOf(protocols);
            if (protocols.contains((Object)SessionProtocol.PROXY)) {
                this.proxiedCandidates = EnumSet.copyOf(this.candidates);
                this.proxiedCandidates.remove((Object)SessionProtocol.PROXY);
            } else {
                this.proxiedCandidates = null;
            }
            this.proxiedAddresses = proxiedAddresses;
            this.timeoutFuture = timeoutFuture;
        }

        @Override
        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            int readableBytes = in.readableBytes();
            SessionProtocol detected = null;
            Iterator i = this.candidates.iterator();
            while (i.hasNext()) {
                SessionProtocol protocol = (SessionProtocol)((Object)i.next());
                switch (protocol) {
                    case HTTPS: {
                        if (readableBytes < 5) break;
                        if (SslHandler.isEncrypted(in)) {
                            detected = SessionProtocol.HTTPS;
                            break;
                        }
                        i.remove();
                        break;
                    }
                    case PROXY: {
                        assert (PROXY_V1_MAGIC_BYTES.length < PROXY_V2_MAGIC_BYTES.length);
                        if (readableBytes < PROXY_V1_MAGIC_BYTES.length) break;
                        if (this.match(PROXY_V1_MAGIC_BYTES, in)) {
                            detected = SessionProtocol.PROXY;
                            break;
                        }
                        if (readableBytes < PROXY_V2_MAGIC_BYTES.length) break;
                        if (this.match(PROXY_V2_MAGIC_BYTES, in)) {
                            detected = SessionProtocol.PROXY;
                            break;
                        }
                        i.remove();
                    }
                }
            }
            if (detected == null) {
                if (this.candidates.size() == 1) {
                    detected = SessionProtocol.HTTP;
                } else {
                    return;
                }
            }
            if (this.timeoutFuture != null) {
                this.timeoutFuture.cancel(false);
            }
            ChannelPipeline p = ctx.pipeline();
            switch (detected) {
                case HTTP: {
                    HttpServerPipelineConfigurator.this.configureHttp(p, this.proxiedAddresses);
                    break;
                }
                case HTTPS: {
                    HttpServerPipelineConfigurator.this.configureHttps(p, this.proxiedAddresses);
                    break;
                }
                case PROXY: {
                    assert (this.proxiedCandidates != null);
                    p.addLast(new HAProxyMessageDecoder(HttpServerPipelineConfigurator.this.config.proxyProtocolMaxTlvSize()));
                    p.addLast(new ProxiedPipelineConfigurator(this.proxiedCandidates));
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            p.remove(this);
        }

        private boolean match(byte[] prefix, ByteBuf buffer) {
            int idx = buffer.readerIndex();
            for (int i = 0; i < prefix.length; ++i) {
                byte b = buffer.getByte(idx + i);
                if (b == prefix[i]) continue;
                return false;
            }
            return true;
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (!Exceptions.isExpected(cause)) {
                logger.warn("{} Unexpected exception while detecting the session protocol.", (Object)ctx, (Object)cause);
            }
            ctx.close();
        }
    }

    private final class Http2PrefaceOrHttpHandler
    extends ByteToMessageDecoder {
        private final ServerHttp1ObjectEncoder responseEncoder;
        private final KeepAliveHandler keepAliveHandler;
        private final HttpServer httpServer;
        @Nullable
        private String name;

        Http2PrefaceOrHttpHandler(ServerHttp1ObjectEncoder responseEncoder, HttpServer httpServer) {
            this.responseEncoder = responseEncoder;
            this.keepAliveHandler = responseEncoder.keepAliveHandler();
            this.httpServer = httpServer;
        }

        @Override
        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            this.keepAliveHandler.initialize(ctx);
            super.handlerAdded(ctx);
            this.name = ctx.name();
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.keepAliveHandler.destroy();
            super.channelInactive(ctx);
        }

        @Override
        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            this.keepAliveHandler.onReadOrWrite();
            if (in.readableBytes() < 4) {
                return;
            }
            if (in.getInt(in.readerIndex()) == 1347569952) {
                this.configureHttp2(ctx);
            } else {
                this.configureHttp1WithUpgrade(ctx);
            }
            ctx.pipeline().remove(this);
        }

        private void configureHttp1WithUpgrade(ChannelHandlerContext ctx) {
            ChannelPipeline p = ctx.pipeline();
            HttpServerCodec http1codec = new HttpServerCodec(HttpServerPipelineConfigurator.this.config.http1MaxInitialLineLength(), HttpServerPipelineConfigurator.this.config.http1MaxHeaderSize(), HttpServerPipelineConfigurator.this.config.http1MaxChunkSize());
            String baseName = this.name;
            assert (baseName != null);
            baseName = this.addAfter(p, baseName, http1codec);
            baseName = this.addAfter(p, baseName, new HttpServerUpgradeHandler(http1codec, () -> new Http2ServerUpgradeCodec(HttpServerPipelineConfigurator.this.newHttp2ConnectionHandler(p, SCHEME_HTTP))));
            Http1RequestDecoder handler = new Http1RequestDecoder(HttpServerPipelineConfigurator.this.config, ctx.channel(), SCHEME_HTTP, this.responseEncoder, this.httpServer);
            this.addAfter(p, baseName, handler);
        }

        private void configureHttp2(ChannelHandlerContext ctx) {
            ChannelPipeline p = ctx.pipeline();
            assert (this.name != null);
            this.addAfter(p, this.name, HttpServerPipelineConfigurator.this.newHttp2ConnectionHandler(p, SCHEME_HTTP));
        }

        private String addAfter(ChannelPipeline p, String baseName, ChannelHandler handler) {
            p.addAfter(baseName, null, handler);
            return p.context(handler).name();
        }
    }

    private final class Http2OrHttpHandler
    extends ApplicationProtocolNegotiationHandler {
        private static final String DUMMY_TLS_PROTOCOL = "NONE";
        private static final String UNKNOWN_TLS_PROTOCOL = "unknown";
        private static final String DUMMY_CIPHER_SUITE = "SSL_NULL_WITH_NULL_NULL";
        @Nullable
        private final ProxiedAddresses proxiedAddresses;
        private boolean loggedHandshakeFailure;
        private boolean addedExceptionLogger;

        Http2OrHttpHandler(ProxiedAddresses proxiedAddresses) {
            super("http/1.1");
            this.proxiedAddresses = proxiedAddresses;
        }

        @Override
        protected void configurePipeline(ChannelHandlerContext ctx, String protocol) throws Exception {
            if ("h2".equals(protocol)) {
                this.recordHandshakeSuccess(ctx, SessionProtocol.H2);
                this.addHttp2Handlers(ctx);
                return;
            }
            if ("http/1.1".equals(protocol)) {
                this.recordHandshakeSuccess(ctx, SessionProtocol.H1);
                this.addHttpHandlers(ctx);
                return;
            }
            throw new SSLHandshakeException("unsupported application protocol: " + protocol);
        }

        private void addHttp2Handlers(ChannelHandlerContext ctx) {
            ChannelPipeline p = ctx.pipeline();
            p.addLast(HttpServerPipelineConfigurator.this.newHttp2ConnectionHandler(p, SCHEME_HTTPS));
            p.addLast(new HttpServerHandler(HttpServerPipelineConfigurator.this.config, p.channel(), HttpServerPipelineConfigurator.this.gracefulShutdownSupport, null, SessionProtocol.H2, this.proxiedAddresses));
        }

        private void addHttpHandlers(ChannelHandlerContext ctx) {
            int maxNumRequestsPerConnection;
            long maxConnectionAgeMillis;
            Channel ch = ctx.channel();
            ChannelPipeline p = ctx.pipeline();
            long idleTimeoutMillis = HttpServerPipelineConfigurator.this.config.idleTimeoutMillis();
            boolean needsKeepAliveHandler = KeepAliveHandlerUtil.needsKeepAliveHandler(idleTimeoutMillis, 0L, maxConnectionAgeMillis = HttpServerPipelineConfigurator.this.config.maxConnectionAgeMillis(), maxNumRequestsPerConnection = HttpServerPipelineConfigurator.this.config.maxNumRequestsPerConnection());
            KeepAliveHandler keepAliveHandler = needsKeepAliveHandler ? new Http1ServerKeepAliveHandler(ch, HttpServerPipelineConfigurator.this.newKeepAliveTimer(SessionProtocol.H1), idleTimeoutMillis, maxConnectionAgeMillis, maxNumRequestsPerConnection) : new NoopKeepAliveHandler();
            ServerHttp1ObjectEncoder encoder = new ServerHttp1ObjectEncoder(ch, SessionProtocol.H1, keepAliveHandler, HttpServerPipelineConfigurator.this.config.http1HeaderNaming());
            p.addLast(new HttpServerCodec(HttpServerPipelineConfigurator.this.config.http1MaxInitialLineLength(), HttpServerPipelineConfigurator.this.config.http1MaxHeaderSize(), HttpServerPipelineConfigurator.this.config.http1MaxChunkSize()));
            HttpServerHandler httpServerHandler = new HttpServerHandler(HttpServerPipelineConfigurator.this.config, ch, HttpServerPipelineConfigurator.this.gracefulShutdownSupport, encoder, SessionProtocol.H1, this.proxiedAddresses);
            p.addLast(new Http1RequestDecoder(HttpServerPipelineConfigurator.this.config, ch, SCHEME_HTTPS, encoder, httpServerHandler));
            p.addLast(httpServerHandler);
        }

        @Override
        protected void handshakeFailure(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            this.exceptionCaught(ctx, cause);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            this.logIfUnexpected(ctx, cause);
            ctx.close();
            if (!this.addedExceptionLogger) {
                this.addedExceptionLogger = true;
                ctx.pipeline().addLast(new ChannelInboundHandlerAdapter(){

                    @Override
                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        Http2OrHttpHandler.this.logIfUnexpected(ctx, cause);
                    }
                });
            }
        }

        private void logIfUnexpected(ChannelHandlerContext ctx, Throwable cause) {
            if (cause instanceof DecoderException) {
                if (this.loggedHandshakeFailure) {
                    if (cause.getCause() instanceof SSLException) {
                        return;
                    }
                } else if (cause.getCause() instanceof SSLHandshakeException) {
                    this.loggedHandshakeFailure = true;
                    SSLHandshakeException handshakeException = (SSLHandshakeException)cause.getCause();
                    this.recordHandshakeFailure(ctx, handshakeException);
                    return;
                }
            }
            Exceptions.logIfUnexpected(logger, ctx.channel(), cause);
        }

        private void recordHandshakeSuccess(ChannelHandlerContext ctx, SessionProtocol protocol) {
            Channel ch = ctx.channel();
            this.incrementHandshakeCounter(ch, protocol, true);
        }

        private void recordHandshakeFailure(ChannelHandlerContext ctx, SSLHandshakeException cause) {
            Channel ch = ctx.channel();
            this.incrementHandshakeCounter(ch, null, false);
            logger.warn("{} TLS handshake failed: {}", (Object)ch, (Object)cause.getMessage());
            if (logger.isDebugEnabled()) {
                logger.debug("{} Stack trace for the TLS handshake failure:", (Object)ch, (Object)cause);
            }
        }

        private void incrementHandshakeCounter(Channel ch, @Nullable SessionProtocol protocol, boolean success) {
            String tlsProtocol;
            String cipherSuite;
            String commonName;
            String protocolText;
            SSLSession sslSession = ChannelUtil.findSslSession(ch);
            String string = protocolText = protocol != null ? protocol.uriText() : "";
            if (sslSession != null) {
                commonName = MoreObjects.firstNonNull(CertificateUtil.getCommonName(sslSession), "");
                cipherSuite = sslSession.getCipherSuite();
                if (cipherSuite == null || DUMMY_CIPHER_SUITE.equals(cipherSuite)) {
                    cipherSuite = "";
                }
                if ((tlsProtocol = sslSession.getProtocol()) == null || UNKNOWN_TLS_PROTOCOL.equals(tlsProtocol) || DUMMY_TLS_PROTOCOL.equals(tlsProtocol)) {
                    tlsProtocol = "";
                }
            } else {
                cipherSuite = "";
                commonName = "";
                tlsProtocol = "";
            }
            Counter.builder("armeria.server.tls.handshakes").tags("cipher.suite", cipherSuite, "common.name", commonName, "protocol", protocolText, "result", success ? "success" : "failure", "tls.protocol", tlsProtocol).register(HttpServerPipelineConfigurator.this.config.meterRegistry()).increment();
        }
    }

    private final class ProxiedPipelineConfigurator
    extends MessageToMessageDecoder<HAProxyMessage> {
        private final EnumSet<SessionProtocol> proxiedCandidates;

        ProxiedPipelineConfigurator(EnumSet<SessionProtocol> proxiedCandidates) {
            this.proxiedCandidates = proxiedCandidates;
        }

        @Override
        protected void decode(ChannelHandlerContext ctx, HAProxyMessage msg, List<Object> out) throws Exception {
            ProxiedAddresses proxiedAddresses;
            if (logger.isDebugEnabled()) {
                logger.debug("PROXY message {}: {}:{} -> {}:{} (next: {})", msg.protocolVersion().name(), msg.sourceAddress(), msg.sourcePort(), msg.destinationAddress(), msg.destinationPort(), this.proxiedCandidates);
            }
            if (msg.proxiedProtocol().addressFamily() == HAProxyProxiedProtocol.AddressFamily.AF_UNSPEC) {
                proxiedAddresses = null;
            } else {
                InetAddress src = InetAddress.getByAddress(NetUtil.createByteArrayFromIpAddressString(msg.sourceAddress()));
                InetAddress dst = InetAddress.getByAddress(NetUtil.createByteArrayFromIpAddressString(msg.destinationAddress()));
                proxiedAddresses = ProxiedAddresses.of(new InetSocketAddress(src, msg.sourcePort()), new InetSocketAddress(dst, msg.destinationPort()));
            }
            ChannelPipeline p = ctx.pipeline();
            HttpServerPipelineConfigurator.this.configurePipeline(p, this.proxiedCandidates, proxiedAddresses);
            p.remove(this);
        }
    }
}

