/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import org.apache.skywalking.oap.server.core.analysis.Disable;
import org.apache.skywalking.oap.server.core.analysis.MultipleDisable;
import org.apache.skywalking.oap.server.core.annotation.AnnotationListener;

public class DisableRegister
implements AnnotationListener {
    public static DisableRegister INSTANCE = new DisableRegister();
    private Set<String> disableEntitySet = new HashSet<String>();

    private DisableRegister() {
    }

    @Override
    public Class<? extends Annotation> annotation() {
        return MultipleDisable.class;
    }

    @Override
    public void notify(Class aClass) {
        MultipleDisable annotation = aClass.getAnnotation(MultipleDisable.class);
        Disable[] valueList = annotation.value();
        if (valueList != null) {
            for (Disable disable : valueList) {
                this.add(disable.value());
            }
        }
    }

    public void add(String name) {
        this.disableEntitySet.add(name);
    }

    public boolean include(String name) {
        return this.disableEntitySet.contains(name);
    }

    public static class SingleDisableScanListener
    implements AnnotationListener {
        @Override
        public Class<? extends Annotation> annotation() {
            return Disable.class;
        }

        @Override
        public void notify(Class aClass) {
            String name = aClass.getAnnotation(Disable.class).value();
            DisableRegister.INSTANCE.disableEntitySet.add(name);
        }
    }
}

