/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.data;

import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.skywalking.oap.server.core.analysis.data.BufferedData;

public class ReadWriteSafeCache<T> {
    private volatile BufferedData<T> readBufferPointer;
    private volatile BufferedData<T> writeBufferPointer;
    private final ReentrantLock lock;

    public ReadWriteSafeCache(BufferedData<T> buffer1, BufferedData<T> buffer2) {
        this.readBufferPointer = buffer1;
        this.writeBufferPointer = buffer2;
        this.lock = new ReentrantLock();
    }

    public void write(T data) {
        this.lock.lock();
        try {
            this.writeBufferPointer.accept(data);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void write(List<T> data) {
        this.lock.lock();
        try {
            data.forEach(this.writeBufferPointer::accept);
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<T> read() {
        this.lock.lock();
        try {
            BufferedData<T> tempPointer = this.writeBufferPointer;
            this.writeBufferPointer = this.readBufferPointer;
            this.readBufferPointer = tempPointer;
        }
        finally {
            this.lock.unlock();
        }
        return this.readBufferPointer.read();
    }
}

