/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.query.enumeration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.skywalking.oap.server.core.UnexpectedException;

public enum ProfilingSupportStatus {
    NOT_SUPPORT(0),
    SUPPORT_EBPF_PROFILING(1);

    private final int value;
    private static final Map<Integer, ProfilingSupportStatus> DICTIONARY;

    private ProfilingSupportStatus(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static ProfilingSupportStatus valueOf(int value) {
        ProfilingSupportStatus type = DICTIONARY.get(value);
        if (type == null) {
            throw new UnexpectedException("Unknown ProfilingSupportStatus value");
        }
        return type;
    }

    static {
        DICTIONARY = new HashMap<Integer, ProfilingSupportStatus>();
        Arrays.stream(ProfilingSupportStatus.values()).collect(Collectors.toMap(ProfilingSupportStatus::value, type -> type)).forEach(DICTIONARY::put);
    }
}

