// Licensed to Apache Software Foundation (ASF) under one or more contributor
// license agreements. See the NOTICE file distributed with
// this work for additional information regarding copyright
// ownership. Apache Software Foundation (ASF) licenses this file to you under
// the Apache License, Version 2.0 (the "License"); you may
// not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package flags

import (
	"github.com/urfave/cli/v2"
)

// ServiceFlags take either service id or service name as input,
// and transform to the other one.
var ServiceFlags = []cli.Flag{
	&cli.StringFlag{
		Name:     "service-id",
		Usage:    "`service id`, if you don't have service id, use `--service-name` instead",
		Required: false,
	},
	&cli.StringFlag{
		Name:     "service-name",
		Usage:    "`service name`, if you already have service id, prefer to use `--service-id`",
		Required: false,
	},
}

// ServiceRelationFlags take either destination service id or destination service name as input,
// and transform to the other one.
var ServiceRelationFlags = append(
	ServiceFlags,

	&cli.StringFlag{
		Name:     "dest-service-id",
		Usage:    "`destination` service id, if you don't have service id, use `--dest-service-name` instead",
		Required: false,
	},
	&cli.StringFlag{
		Name:     "dest-service-name",
		Usage:    "`destination` service name, if you already have service id, prefer to use `--dest-service-id`",
		Required: false,
	},
)
