/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bgservlets.impl.storage;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.bgservlets.JobData;
import org.apache.sling.bgservlets.JobStorage;
import org.apache.sling.bgservlets.impl.DeepNodeCreator;
import org.apache.sling.bgservlets.impl.storage.JobDataImpl;
import org.apache.sling.bgservlets.impl.storage.JobStorageException;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="%JobStorage.label", description="%JobStorage.description")
@Service
public class JobStorageImpl
implements JobStorage {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Property(value={"/var/bg/jobs"})
    public static final String PROP_JOB_STORAGE_PATH = "job.storage.path";
    @Reference
    private SlingSettingsService slingSettings;
    public static final String PATH_FORMAT = "/yyyy/MM/dd/HH/mm";
    public static final String JOB_NODETYPE = "nt:unstructured";
    private String jobStoragePath;
    private AtomicInteger counter = new AtomicInteger();
    private static final DateFormat pathFormat = new SimpleDateFormat("/yyyy/MM/dd/HH/mm");
    private String slingInstanceId;

    @Activate
    protected void activate(Map<String, Object> props) {
        this.jobStoragePath = (String)props.get(PROP_JOB_STORAGE_PATH);
        if (this.jobStoragePath == null || this.jobStoragePath.length() == 0) {
            throw new IllegalStateException("Missing job.storage.path in ComponentContext");
        }
        if (!this.jobStoragePath.startsWith("/")) {
            this.jobStoragePath = "/" + this.jobStoragePath;
        }
        if (this.jobStoragePath.endsWith("/")) {
            this.jobStoragePath = this.jobStoragePath.substring(0, this.jobStoragePath.length() - 1);
        }
        this.slingInstanceId = this.slingSettings.getSlingId();
        this.log.info("Jobs will be stored under {}/{}", (Object)this.jobStoragePath, (Object)this.slingInstanceId);
    }

    @Override
    public JobData createJobData(Session s) {
        try {
            return this.getJobData(this.createNewJobNode(s));
        }
        catch (Exception e) {
            throw new JobStorageException("Unable to create new JobDataImpl", e);
        }
    }

    @Override
    public JobData getJobData(Node n) {
        try {
            return new JobDataImpl(n);
        }
        catch (Exception e) {
            throw new JobStorageException("Unable to create JobDataImpl", e);
        }
    }

    String getNextPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.jobStoragePath);
        sb.append("/").append(this.slingInstanceId);
        sb.append(pathFormat.format(new Date())).append("/");
        sb.append(this.counter.incrementAndGet());
        return sb.toString();
    }

    Node createNewJobNode(Session s) throws RepositoryException {
        String path = this.getNextPath();
        Node result = new DeepNodeCreator().deepCreateNode(path, s, JOB_NODETYPE);
        result.addMixin("sling:bgJobData");
        result.setProperty("jcr:created", Calendar.getInstance());
        result.getSession().save();
        this.log.debug("Job node {} created", (Object)result.getPath());
        return result;
    }

    protected void bindSlingSettings(SlingSettingsService slingSettingsService) {
        this.slingSettings = slingSettingsService;
    }

    protected void unbindSlingSettings(SlingSettingsService slingSettingsService) {
        if (this.slingSettings == slingSettingsService) {
            this.slingSettings = null;
        }
    }
}

