/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.insights.impl.providers;

import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.sling.cms.core.insights.impl.BaseInsightProvider;
import org.apache.sling.cms.i18n.I18NDictionary;
import org.apache.sling.cms.i18n.I18NProvider;
import org.apache.sling.cms.insights.Insight;
import org.apache.sling.cms.insights.InsightProvider;
import org.apache.sling.cms.insights.InsightRequest;
import org.apache.sling.cms.insights.Message;
import org.apache.sling.cms.insights.PageInsightRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={InsightProvider.class}, immediate=true)
@Designate(ocd=Config.class)
public class HTMLValdiatorInsightProvider
extends BaseInsightProvider {
    public static final String I18N_KEY_HTMLVALIDATOR_DANGER = "There were {0} validation errors and {1} warnings";
    public static final String I18N_KEY_HTMLVALIDATOR_WARN = "There were {0} validation warnings";
    public static final String I18N_KEY_HTMLVALIDATOR_SUCCESS = "HTML Validation successful!";
    @Reference
    private I18NProvider i18nProvider;
    private static final Logger log = LoggerFactory.getLogger(HTMLValdiatorInsightProvider.class);
    private Config config;

    @Activate
    public void activate(Config config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Insight doEvaluateRequest(InsightRequest request) throws Exception {
        Insight insight = new Insight((InsightProvider)this, request);
        insight.setScored(true);
        PageInsightRequest pageRequest = (PageInsightRequest)request;
        String html = pageRequest.getPageHtml();
        HttpPost httpPost = new HttpPost("http://validator.w3.org/nu/?out=json&showsource=no&level=all");
        httpPost.addHeader("Content-type", "text/html; charset=utf-8");
        ByteArrayEntity htmlEntity = new ByteArrayEntity(html.getBytes(StandardCharsets.UTF_8));
        httpPost.setEntity((HttpEntity)htmlEntity);
        I18NDictionary dictionary = this.i18nProvider.getDictionary(request.getResource().getResourceResolver());
        CloseableHttpResponse response = null;
        try (JsonReader reader = null;
             CloseableHttpClient client = HttpClients.createDefault();){
            response = client.execute((HttpUriRequest)httpPost);
            HttpEntity entity = response.getEntity();
            reader = Json.createReader((Reader)new StringReader(EntityUtils.toString((HttpEntity)entity)));
            JsonObject json = reader.readObject();
            log.debug("Loaded response: {}", (Object)json);
            JsonArray messages = json.getJsonArray("messages");
            int errors = 0;
            int warnings = 0;
            HashSet<String> msgSet = new HashSet<String>();
            for (int i = 0; i < messages.size(); ++i) {
                String messageStr;
                JsonObject message = messages.getJsonObject(i);
                if ("error".equals(message.getString("type"))) {
                    ++errors;
                    messageStr = message.getString("message");
                    if (msgSet.contains(messageStr)) continue;
                    insight.addMessage(Message.danger((String)messageStr));
                    msgSet.add(messageStr);
                    continue;
                }
                if (!"info".equals(message.getString("type")) || !message.containsKey((Object)"subtype") || !"warning".equals(message.getString("subtype"))) continue;
                ++warnings;
                messageStr = message.getString("message");
                if (msgSet.contains(messageStr)) continue;
                insight.addMessage(Message.warn((String)messageStr));
                msgSet.add(messageStr);
            }
            this.updateInsight(insight, pageRequest, dictionary, errors, warnings);
        }
        return insight;
    }

    private void updateInsight(Insight insight, PageInsightRequest pageRequest, I18NDictionary dictionary, int errors, int warnings) throws UnsupportedEncodingException {
        double score;
        if (errors > 5) {
            insight.setPrimaryMessage(Message.danger((String)dictionary.get(I18N_KEY_HTMLVALIDATOR_DANGER, new Object[]{errors, warnings})));
            score = 0.2;
        } else if (errors > 0) {
            insight.setPrimaryMessage(Message.danger((String)dictionary.get(I18N_KEY_HTMLVALIDATOR_DANGER, new Object[]{errors, warnings})));
            score = 0.4;
        } else if (warnings > 5) {
            insight.setPrimaryMessage(Message.warn((String)dictionary.get(I18N_KEY_HTMLVALIDATOR_WARN, new Object[]{warnings})));
            score = 0.6;
        } else if (warnings > 0) {
            insight.setPrimaryMessage(Message.warn((String)dictionary.get(I18N_KEY_HTMLVALIDATOR_WARN, new Object[]{warnings})));
            score = 0.8;
        } else {
            insight.setPrimaryMessage(Message.success((String)dictionary.get(I18N_KEY_HTMLVALIDATOR_SUCCESS)));
            score = 1.0;
        }
        insight.setScore(score);
        insight.setMoreDetailsLink("https://validator.w3.org/nu/?doc=" + URLEncoder.encode(pageRequest.getPage().getPublishedUrl(), StandardCharsets.UTF_8.toString()));
    }

    public String getId() {
        return "htmlvalidator";
    }

    public String getTitle() {
        return "HTML Validator";
    }

    public boolean isEnabled(InsightRequest request) {
        if (!this.config.enabled()) {
            log.debug("HTML Validator is not enabled");
            return false;
        }
        if (request.getType() != InsightRequest.TYPE.PAGE) {
            log.debug("Request {} is not a page", (Object)request);
            return false;
        }
        return true;
    }

    @ObjectClassDefinition(name="%htmlvalidator.config.name", description="%htmlvalidator.config.description", localization="OSGI-INF/l10n/bundle")
    public static @interface Config {
        @AttributeDefinition(name="%htmlvalidator.param.enabled.name", description="%htmlvalidator.param.enabled.description")
        public boolean enabled() default true;
    }
}

