/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal;

import java.util.Optional;
import javax.script.Bindings;
import javax.servlet.ServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.LazyBindings;
import org.apache.sling.cms.CMSUtils;
import org.apache.sling.cms.ComponentConfiguration;
import org.apache.sling.cms.Page;
import org.apache.sling.scripting.api.BindingsValuesProvider;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={BindingsValuesProvider.class}, property={"service.ranking=100"})
public class DefaultScriptBindingsValueProvider
implements BindingsValuesProvider {
    public static final String PN_CURRENT_PAGE = "currentPage";
    public static final String PN_CURRENT_PAGE_EVALUATED = "org.apache.sling.cms.core.internal.DefaultScriptBindingsValueProvider_currentPage_evaluated";

    public void addBindings(Bindings bindings) {
        Resource resource = (Resource)bindings.get("resource");
        this.bindLazy((LazyBindings)bindings, resource);
    }

    private void bindLazy(LazyBindings bindings, final Resource resource) {
        bindings.put("properties", (Object)new LazyBindings.Supplier(){

            public Object get() {
                return resource.getValueMap();
            }
        });
        bindings.put("componentConfiguration", (Object)new LazyBindings.Supplier(){

            public Object get() {
                return Optional.ofNullable((ComponentConfiguration)resource.adaptTo(ComponentConfiguration.class)).map(ComponentConfiguration::getProperties).orElse(null);
            }
        });
        bindings.put("page", (Object)new LazyBindings.Supplier(){

            public Object get() {
                Resource publishableParent = CMSUtils.findPublishableParent((Resource)resource);
                if (publishableParent != null && "sling:Page".equals(publishableParent.getResourceType())) {
                    return publishableParent.adaptTo(Page.class);
                }
                return null;
            }
        });
        ServletRequest request = (ServletRequest)bindings.get((Object)"request");
        if (request.getAttribute(PN_CURRENT_PAGE_EVALUATED) == null) {
            Resource publishableParent = CMSUtils.findPublishableParent((Resource)resource);
            if (publishableParent != null && "sling:Page".equals(publishableParent.getResourceType())) {
                Optional.of((Page)publishableParent.adaptTo(Page.class)).ifPresent(p -> {
                    bindings.put("page", p);
                    if (request.getAttribute(PN_CURRENT_PAGE) == null) {
                        request.setAttribute(PN_CURRENT_PAGE, p);
                        bindings.put(PN_CURRENT_PAGE, p);
                    } else {
                        bindings.put(PN_CURRENT_PAGE, request.getAttribute(PN_CURRENT_PAGE));
                    }
                });
            }
            request.setAttribute(PN_CURRENT_PAGE_EVALUATED, (Object)true);
        }
    }
}

