/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.models;

import java.util.ArrayList;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.cms.CMSUtils;
import org.apache.sling.cms.Page;
import org.apache.sling.cms.PageTemplate;
import org.apache.sling.cms.Site;
import org.apache.sling.cms.core.internal.models.PublishableResourceImpl;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;

@Model(adaptables={Resource.class}, adapters={Page.class})
public class PageImpl
extends PublishableResourceImpl
implements Page {
    private final String[] taxonomy;
    private final String template;
    private final String title;

    public static final Page getContainingPage(Resource resource) {
        Resource pageRsrc = CMSUtils.findParentResourceofType((Resource)resource, (String)"sling:Page");
        Page page = null;
        if (pageRsrc != null) {
            page = (Page)pageRsrc.adaptTo(Page.class);
        }
        return page;
    }

    @Inject
    public PageImpl(@Self Resource resource) {
        super(resource);
        if (this.getContentResource() != null) {
            ValueMap properties = this.getContentResource().getValueMap();
            this.taxonomy = (String[])properties.get("sling:taxonomy", String[].class);
            this.template = (String)properties.get("sling:template", String.class);
            this.title = (String)properties.get("jcr:title", String.class);
        } else {
            this.taxonomy = new String[0];
            this.template = null;
            this.title = null;
        }
    }

    public String[] getKeywords() {
        ArrayList<String> keywords = new ArrayList<String>();
        if (this.taxonomy != null) {
            for (String item : this.taxonomy) {
                Resource rsrc = this.resource.getResourceResolver().getResource(item);
                if (rsrc == null) continue;
                keywords.add((String)rsrc.getValueMap().get("jcr:title", String.class));
            }
        }
        return keywords.toArray(new String[keywords.size()]);
    }

    @Override
    public String getPublishedPath() {
        Site site = this.getSite();
        if (site != null) {
            return this.resource.getPath().replace(site.getPath(), "") + ".html";
        }
        return this.resource.getPath() + ".html";
    }

    public PageTemplate getTemplate() {
        Resource templateResource = this.resource.getResourceResolver().getResource(this.template);
        if (templateResource != null) {
            return (PageTemplate)templateResource.adaptTo(PageTemplate.class);
        }
        return null;
    }

    public String getTemplatePath() {
        return this.template;
    }

    public String getTitle() {
        if (StringUtils.isNotEmpty((CharSequence)this.title)) {
            return this.title;
        }
        return this.resource.getName();
    }
}

