/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.operations;

import java.util.ArrayList;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.cms.AuthorizableWrapper;
import org.apache.sling.servlets.post.PostOperation;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={PostOperation.class}, property={"sling.post.operation=changepassword"})
public class ChangePasswordOperation
implements PostOperation {
    private static final Logger log = LoggerFactory.getLogger(ChangePasswordOperation.class);

    public void run(SlingHttpServletRequest request, PostResponse response, SlingPostProcessor[] processors) {
        ArrayList changes = new ArrayList();
        try {
            String password = request.getParameter(":password");
            AuthorizableWrapper authWrapper = (AuthorizableWrapper)request.getResource().adaptTo(AuthorizableWrapper.class);
            if (authWrapper.getAuthorizable().isGroup()) {
                throw new RepositoryException("Authorizable is a group!");
            }
            User user = (User)authWrapper.getAuthorizable();
            user.changePassword(password);
            if (processors != null) {
                for (SlingPostProcessor processor : processors) {
                    processor.process(request, changes);
                }
            }
            request.getResourceResolver().commit();
            response.setPath(user.getPath());
            response.onModified(user.getPath());
        }
        catch (Exception e) {
            log.warn("Failed to change user password", (Throwable)e);
            response.setError((Throwable)e);
        }
    }
}

