/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.models;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
@ProviderType
public class QueryDebugger {
    private static final String MBEAN_NAME = "org.apache.jackrabbit.oak:name=Oak Query Statistics (Extended),type=QueryStats";
    private static final Logger log = LoggerFactory.getLogger(QueryDebugger.class);
    private final String plan;
    private final long duration;
    private final long estimatedSize;
    private final String exception;
    private final List<Resource> results = new ArrayList<Resource>();
    private final String statement;
    private final List<Map<String, Object>> slowQueries = new ArrayList<Map<String, Object>>();
    private final List<Map<String, Object>> popularQueries = new ArrayList<Map<String, Object>>();
    private final boolean enabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject
    public QueryDebugger(@Self SlingHttpServletRequest request) {
        Optional<String> statementParam = Optional.ofNullable(request.getParameter("statement"));
        String language = Optional.ofNullable(request.getParameter("language")).orElse("JCR-SQL2");
        int limit = Optional.ofNullable(request.getParameter("sample")).map(s -> Integer.parseInt(s, 10)).orElse(0);
        boolean lenabled = false;
        long lestimate = 0L;
        long lduration = -1L;
        String lplan = null;
        String lexception = null;
        String lstatement = null;
        try {
            if (statementParam.isPresent()) {
                QueryManager queryManager = ((Session)request.getResourceResolver().adaptTo(Session.class)).getWorkspace().getQueryManager();
                Query explainQuery = queryManager.createQuery("explain measure " + statementParam.get(), language);
                Row row = explainQuery.execute().getRows().nextRow();
                lplan = row.getValue("plan").getString();
                lstatement = statementParam.get();
                if (limit > 0) {
                    lenabled = true;
                    long start = System.currentTimeMillis();
                    Query query = queryManager.createQuery(statementParam.get(), language);
                    query.setLimit((long)limit);
                    QueryResult queryResult = query.execute();
                    RowIterator rowIterator = queryResult.getRows();
                    lestimate = rowIterator.getSize();
                    lduration = System.currentTimeMillis() - start;
                    while (rowIterator.hasNext()) {
                        Optional.ofNullable(rowIterator.nextRow()).map(n -> {
                            try {
                                return request.getResourceResolver().getResource(n.getPath());
                            }
                            catch (RepositoryException e) {
                                log.warn("Exception getting path from row: {}", n, (Object)e);
                                return null;
                            }
                        }).ifPresent(this.results::add);
                    }
                }
            }
        }
        catch (RepositoryException re) {
            lexception = re.toString();
            log.warn("Failed to debug query: {}", statementParam, (Object)re);
        }
        finally {
            this.plan = lplan;
            this.duration = lduration;
            this.exception = lexception;
            this.statement = lstatement;
            this.estimatedSize = lestimate;
            this.enabled = lenabled;
        }
        try {
            this.collectMbeanData("PopularQueries", this.popularQueries);
            this.collectMbeanData("SlowQueries", this.slowQueries);
        }
        catch (NullPointerException | AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            log.warn("Failed to load mBean data", (Throwable)e);
        }
    }

    private void collectMbeanData(String attributeName, List<Map<String, Object>> target) throws MalformedObjectNameException, NullPointerException, InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ObjectName mbeanName = ObjectName.getInstance(MBEAN_NAME);
        TabularData data = (TabularData)mBeanServer.getAttribute(mbeanName, attributeName);
        data.values().stream().map(CompositeData.class::cast).forEach(compositeData -> target.add(compositeData.getCompositeType().keySet().stream().collect(Collectors.toMap(k -> k, compositeData::get))));
    }

    public long getDuration() {
        return this.duration;
    }

    public long getEstimatedSize() {
        return this.estimatedSize;
    }

    public boolean isExecutionEnabled() {
        return this.enabled;
    }

    public String getException() {
        return this.exception;
    }

    public String getPlan() {
        return this.plan;
    }

    public List<Resource> getResults() {
        return this.results;
    }

    public String getStatement() {
        return this.statement;
    }

    public List<Map<String, Object>> getSlowQueries() {
        return this.slowQueries;
    }

    public List<Map<String, Object>> getPopularQueries() {
        return this.popularQueries;
    }
}

