/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.crypto.internal;

import java.util.Objects;
import org.apache.sling.commons.crypto.PasswordProvider;
import org.apache.sling.commons.crypto.internal.EnvironmentVariablePasswordProviderConfiguration;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Apache Sling Commons Crypto \u2013 Environment Variable Password Provider", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=EnvironmentVariablePasswordProviderConfiguration.class, factory=true)
public final class EnvironmentVariablePasswordProvider
implements PasswordProvider {
    private EnvironmentVariablePasswordProviderConfiguration configuration;
    private final Logger logger = LoggerFactory.getLogger(EnvironmentVariablePasswordProvider.class);

    @Activate
    private void activate(EnvironmentVariablePasswordProviderConfiguration configuration) {
        this.logger.debug("activating");
        this.configuration = configuration;
    }

    @Modified
    private void modified(EnvironmentVariablePasswordProviderConfiguration configuration) {
        this.logger.debug("modifying");
        this.configuration = configuration;
    }

    @Deactivate
    private void deactivate() {
        this.logger.debug("deactivating");
    }

    @Override
    public char @NotNull [] getPassword() {
        EnvironmentVariablePasswordProviderConfiguration configuration = this.configuration;
        Objects.requireNonNull(configuration, "Configuration must not be null");
        String name = configuration.name();
        if (Objects.isNull(System.getenv(name))) {
            String message = String.format("environment variable '%s' not set", name);
            throw new RuntimeException(message);
        }
        return System.getenv(name).toCharArray();
    }
}

