/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.crypto.internal;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Objects;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.sling.commons.crypto.PasswordProvider;
import org.apache.sling.commons.crypto.SaltProvider;
import org.apache.sling.commons.crypto.SecretKeyProvider;
import org.apache.sling.commons.crypto.internal.PbeSecretKeyProviderConfiguration;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Apache Sling Commons Crypto \u2013 PBE SecretKey Provider", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=PbeSecretKeyProviderConfiguration.class, factory=true)
public final class PbeSecretKeyProvider
implements SecretKeyProvider {
    @Reference
    private volatile PasswordProvider passwordProvider;
    @Reference
    private volatile SaltProvider saltProvider;
    private PbeSecretKeyProviderConfiguration configuration;
    private SecretKeyFactory factory;
    private final Logger logger = LoggerFactory.getLogger(PbeSecretKeyProvider.class);

    @Activate
    private void activate(PbeSecretKeyProviderConfiguration configuration) throws NoSuchAlgorithmException {
        this.logger.debug("activating");
        this.configuration = configuration;
        this.factory = SecretKeyFactory.getInstance(configuration.algorithm());
    }

    @Modified
    private void modified(PbeSecretKeyProviderConfiguration configuration) throws NoSuchAlgorithmException {
        this.logger.debug("modifying");
        this.configuration = configuration;
        this.factory = SecretKeyFactory.getInstance(configuration.algorithm());
    }

    @Deactivate
    protected void deactivate() {
        this.logger.debug("deactivating");
    }

    @Override
    @NotNull
    public SecretKey getSecretKey() {
        PbeSecretKeyProviderConfiguration configuration = this.configuration;
        Objects.requireNonNull(configuration, "Configuration must not be null");
        try {
            PBEKeySpec keySpec = new PBEKeySpec(this.passwordProvider.getPassword(), this.saltProvider.getSalt(), configuration.iterationCount(), configuration.keyLength());
            return this.factory.generateSecret(keySpec);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }
}

