/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.threads.impl;

import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.apache.sling.commons.threads.impl.ThreadLocalChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLocalCleaner {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadLocalCleaner.class);
    private static final Field threadLocalsField;
    private static final Field inheritableThreadLocalsField;
    private static final Class<?> threadLocalMapClass;
    private static final Field tableField;
    private static final Class<?> threadLocalMapEntryClass;
    private static final Field threadLocalEntryValueField;
    private static final Field threadLocalMapSizeField;
    private static final Field threadLocalMapThresholdField;
    private final ThreadLocalChangeListener listener;
    private ThreadLocalMapCopy threadLocalsCopy;
    private ThreadLocalMapCopy inheritableThreadLocalsCopy;

    static void validate() {
        LOG.info("Validating reflective access is permitted... ");
        Reference<?>[] threadLocals = ThreadLocalCleaner.copy(threadLocalsField);
        if (threadLocals == null) {
            LOG.info("Accessed thread locals of current thread, found none");
        } else {
            LOG.info("Accessed thread locals of current thread, found {}", (Object)threadLocals.length);
        }
    }

    private static Field field(Class<?> c, String name) throws NoSuchFieldException {
        Field field = c.getDeclaredField(name);
        field.setAccessible(true);
        return field;
    }

    private static Class<?> inner(Class<?> clazz, String name) {
        for (Class<?> c : clazz.getDeclaredClasses()) {
            if (!c.getSimpleName().equals(name)) continue;
            return c;
        }
        throw new IllegalStateException("Could not find inner class " + name + " in " + clazz);
    }

    private static Reference<?>[] copy(Field field) {
        try {
            Thread thread = Thread.currentThread();
            Object threadLocals = field.get(thread);
            if (threadLocals == null) {
                return null;
            }
            Reference[] table = (Reference[])tableField.get(threadLocals);
            return Arrays.copyOf(table, table.length);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Access denied", e);
        }
    }

    private static Integer size(Field field, Field sizeField) {
        try {
            Thread thread = Thread.currentThread();
            Object threadLocals = field.get(thread);
            if (threadLocals == null) {
                return null;
            }
            return (Integer)sizeField.get(threadLocals);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Access denied", e);
        }
    }

    private static void restore(Field field, Object[] value, Integer size, Integer threshold) {
        try {
            Thread thread = Thread.currentThread();
            if (value == null) {
                field.set(thread, null);
                LOG.debug("Restored {} to a null value", (Object)field.getName());
            } else {
                Object threadLocals = field.get(thread);
                tableField.set(threadLocals, value);
                threadLocalMapSizeField.set(threadLocals, size);
                threadLocalMapThresholdField.set(threadLocals, threshold);
                LOG.debug("Restored {} with to {} references, size {}, threshold {}", new Object[]{field.getName(), value.length, size, threshold});
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Access denied", e);
        }
    }

    public ThreadLocalCleaner(ThreadLocalChangeListener listener) {
        this.listener = listener;
        this.saveOldThreadLocals();
    }

    public void cleanup() {
        if (this.listener.isEnabled()) {
            this.diff(threadLocalsField, this.threadLocalsCopy.references);
            this.diff(inheritableThreadLocalsField, this.inheritableThreadLocalsCopy.references);
        }
        this.restoreOldThreadLocals();
    }

    private void diff(Field field, Reference<?>[] backup) {
        try {
            Thread thread = Thread.currentThread();
            Object threadLocals = field.get(thread);
            if (threadLocals == null) {
                if (backup != null) {
                    for (Reference<?> reference : backup) {
                        this.changed(thread, reference, ThreadLocalChangeListener.Mode.REMOVED);
                    }
                }
                return;
            }
            Reference[] current = (Reference[])tableField.get(threadLocals);
            if (backup == null) {
                for (Reference reference : current) {
                    this.changed(thread, reference, ThreadLocalChangeListener.Mode.ADDED);
                }
            } else {
                block4: for (Reference reference : current) {
                    if (reference == null || reference.get() == this.threadLocalsCopy || reference.get() == this.inheritableThreadLocalsCopy) continue;
                    for (Reference reference2 : backup) {
                        if (reference == reference2) continue block4;
                    }
                    this.changed(thread, reference, ThreadLocalChangeListener.Mode.ADDED);
                }
                block6: for (Reference reference : backup) {
                    for (Reference reference3 : current) {
                        if (reference3 == reference) continue block6;
                    }
                    this.changed(thread, reference, ThreadLocalChangeListener.Mode.REMOVED);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Access denied", e);
        }
    }

    private void changed(Thread thread, Reference<?> reference, ThreadLocalChangeListener.Mode mode) throws IllegalAccessException {
        if (reference != null) {
            this.listener.changed(mode, thread, (ThreadLocal)reference.get(), threadLocalEntryValueField.get(reference));
        }
    }

    private void saveOldThreadLocals() {
        this.threadLocalsCopy = new ThreadLocalMapCopy(ThreadLocalCleaner.copy(threadLocalsField), ThreadLocalCleaner.size(threadLocalsField, threadLocalMapSizeField), ThreadLocalCleaner.size(threadLocalsField, threadLocalMapThresholdField));
        this.threadLocalsCopy.debug("saved", "Thread locals");
        this.inheritableThreadLocalsCopy = new ThreadLocalMapCopy(ThreadLocalCleaner.copy(inheritableThreadLocalsField), ThreadLocalCleaner.size(inheritableThreadLocalsField, threadLocalMapSizeField), ThreadLocalCleaner.size(inheritableThreadLocalsField, threadLocalMapThresholdField));
        this.inheritableThreadLocalsCopy.debug("saved", "Inheritable thread locals");
    }

    private void restoreOldThreadLocals() {
        try {
            ThreadLocalCleaner.restore(inheritableThreadLocalsField, this.inheritableThreadLocalsCopy.references, this.inheritableThreadLocalsCopy.size, this.inheritableThreadLocalsCopy.threshold);
            ThreadLocalCleaner.restore(threadLocalsField, this.threadLocalsCopy.references, this.threadLocalsCopy.size, this.threadLocalsCopy.threshold);
        }
        finally {
            this.threadLocalsCopy = null;
            this.inheritableThreadLocalsCopy = null;
        }
    }

    static {
        try {
            threadLocalsField = ThreadLocalCleaner.field(Thread.class, "threadLocals");
            inheritableThreadLocalsField = ThreadLocalCleaner.field(Thread.class, "inheritableThreadLocals");
            threadLocalMapClass = ThreadLocalCleaner.inner(ThreadLocal.class, "ThreadLocalMap");
            tableField = ThreadLocalCleaner.field(threadLocalMapClass, "table");
            threadLocalMapEntryClass = ThreadLocalCleaner.inner(threadLocalMapClass, "Entry");
            threadLocalEntryValueField = ThreadLocalCleaner.field(threadLocalMapEntryClass, "value");
            threadLocalMapSizeField = ThreadLocalCleaner.field(threadLocalMapClass, "size");
            threadLocalMapThresholdField = ThreadLocalCleaner.field(threadLocalMapClass, "threshold");
        }
        catch (NoSuchFieldException e) {
            ExceptionInInitializerError error = new ExceptionInInitializerError("Unable to access ThreadLocal class information using reflection");
            error.initCause(e);
            throw error;
        }
    }

    static class ThreadLocalMapCopy {
        private final Reference<?>[] references;
        private final Integer size;
        private final Integer threshold;

        private ThreadLocalMapCopy(Reference<?>[] references, Integer size, Integer threshold) {
            this.references = references;
            this.size = size;
            this.threshold = threshold;
        }

        void debug(String event, String mapName) {
            if (this.references != null) {
                LOG.debug("{}: {} {} references, size: {}, threshold: {}", new Object[]{mapName, event, this.references.length, this.size, this.threshold});
            } else {
                LOG.debug("{}: {} null references", (Object)mapName, (Object)event);
            }
        }
    }
}

