/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.discovery.base.connectors.ping;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.apache.sling.discovery.base.connectors.BaseConfig;
import org.apache.sling.discovery.base.connectors.ping.TopologyRequestValidator;
import org.apache.sling.discovery.base.its.setup.mock.SimpleConnectorConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TopologyRequestValidatorTest {
    private TopologyRequestValidator topologyRequestValidator;

    @Before
    public void before() throws SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        SimpleConnectorConfig config = new SimpleConnectorConfig();
        this.setPrivate(config, "sharedKey", "testKey");
        this.setPrivate(config, "hmacEnabled", true);
        this.setPrivate(config, "encryptionEnabled", true);
        this.setPrivate(config, "keyInterval", 1440000);
        this.topologyRequestValidator = new TopologyRequestValidator((BaseConfig)config);
    }

    private void setPrivate(Object o, String field, Object value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = o.getClass().getDeclaredField(field);
        if (!f.isAccessible()) {
            f.setAccessible(true);
        }
        f.set(o, value);
    }

    @Test
    public void testTrustRequest() throws IOException {
        HttpPut method = new HttpPut("/TestUri");
        String clearMessage = "TestMessage";
        String message = this.topologyRequestValidator.encodeMessage(clearMessage);
        Assert.assertNotNull((Object)message);
        Assert.assertNotEquals((Object)message, (Object)clearMessage);
        this.topologyRequestValidator.trustMessage((HttpUriRequest)method, message);
        Assert.assertNotNull((Object)method.getFirstHeader("X-SlingTopologyHash"));
        Assert.assertNotNull((Object)method.getFirstHeader("X-SlingTopologyHash").getValue());
        Assert.assertTrue((method.getFirstHeader("X-SlingTopologyHash").getValue().length() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)method.getFirstHeader("X-SlingTopologyTrust"));
        Assert.assertNotNull((Object)method.getFirstHeader("X-SlingTopologyTrust").getValue());
        Assert.assertTrue((method.getFirstHeader("X-SlingTopologyTrust").getValue().length() > 0 ? 1 : 0) != 0);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getHeader("X-SlingTopologyHash")).thenReturn((Object)method.getFirstHeader("X-SlingTopologyHash").getValue());
        Mockito.when((Object)request.getHeader("X-SlingTopologyTrust")).thenReturn((Object)method.getFirstHeader("X-SlingTopologyTrust").getValue());
        Mockito.when((Object)request.getHeader("Content-Encoding")).thenReturn((Object)"");
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)method.getURI().getPath());
        Mockito.when((Object)request.getReader()).thenReturn((Object)new BufferedReader(new StringReader(message)));
        Assert.assertTrue((boolean)this.topologyRequestValidator.isTrusted(request));
        Assert.assertEquals((Object)clearMessage, (Object)this.topologyRequestValidator.decodeMessage(request));
    }

    @Test
    public void testTrustResponse() throws IOException {
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)"/Test/Uri2");
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        final HashMap headers = new HashMap();
        ((HttpServletResponse)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                headers.put(invocation.getArgument(0), invocation.getArgument(1));
                return null;
            }
        }).when((Object)response)).setHeader(Mockito.anyString(), Mockito.anyString());
        String clearMessage = "TestMessage2";
        String message = this.topologyRequestValidator.encodeMessage(clearMessage);
        this.topologyRequestValidator.trustMessage(response, request, message);
        HttpEntity responseEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)responseEntity.getContent()).thenReturn((Object)new ByteArrayInputStream(message.getBytes()));
        HttpResponse resp = (HttpResponse)Mockito.mock(HttpResponse.class);
        Mockito.when((Object)resp.getFirstHeader(Mockito.anyString())).thenAnswer((Answer)new Answer<BasicHeader>(){

            public BasicHeader answer(InvocationOnMock invocation) throws Throwable {
                String headerName = (String)invocation.getArgument(0);
                String headerValue = (String)headers.get(headerName);
                return new BasicHeader(headerName, headerValue);
            }
        });
        Mockito.when((Object)resp.getEntity()).thenReturn((Object)responseEntity);
        this.topologyRequestValidator.isTrusted(resp);
        this.topologyRequestValidator.decodeMessage("/Test/Uri2", resp);
    }
}

