/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.diff;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.sling.feature.Feature;

public final class DiffRequest {
    private final Set<String> includeComparators = new HashSet<String>();
    private final Set<String> excludeComparators = new HashSet<String>();
    private Feature previous;
    private Feature current;

    public Feature getPrevious() {
        return this.previous;
    }

    public DiffRequest setPrevious(Feature previous) {
        this.previous = Objects.requireNonNull(previous, "Impossible to compare null previous feature.");
        return this;
    }

    public Feature getCurrent() {
        return this.current;
    }

    public DiffRequest setCurrent(Feature current) {
        this.current = Objects.requireNonNull(current, "Impossible to compare null current feature.");
        return this;
    }

    public DiffRequest addIncludeComparator(String includeComparator) {
        this.includeComparators.add(Objects.requireNonNull(includeComparator, "A null include comparator id is not valid"));
        return this;
    }

    public Set<String> getIncludeComparators() {
        return this.includeComparators;
    }

    public DiffRequest addExcludeComparator(String excludeComparator) {
        this.excludeComparators.add(Objects.requireNonNull(excludeComparator, "A null exclude comparator id is not valid"));
        return this;
    }

    public Set<String> getExcludeComparators() {
        return this.excludeComparators;
    }
}

